/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.loadbalancer.model.transform;

import com.nifty.cloud.sdk.Response;
import com.nifty.cloud.sdk.ResponseMetadata;
import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.loadbalancer.model.DescribeLoadBalancersResult;
import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * DescribeLoadBalancersResponseクラス。<br />
 * このクラスはDescribeLoadBalancersのレスポンスを格納します。
 */
@XStreamAlias("DescribeLoadBalancersResponse")
public class DescribeLoadBalancersResponse implements Response {
	
	/** ロードバランサーの情報セット */
	@XStreamAlias("DescribeLoadBalancersResult")
	private DescribeLoadBalancersResult describeLoadBalancersResult;
	
	/** リクエスト情報 */		
	@XStreamAlias("ResponseMetadata")
	ResponseMetadata responseMetadata;

	
	/**
	 *  ロードバランサーの情報セットを取得します。
	 *
	 * @return  ロードバランサーの情報セット
	 */
	public DescribeLoadBalancersResult getDescribeLoadBalancersResult() {
		return describeLoadBalancersResult;
	}
	/**
	 *  ロードバランサーの情報セットを設定します。
	 *
	 * @param describeLoadBalancersResult ロードバランサーの情報セット
	 */
	public void setDescribeLoadBalancersResult(DescribeLoadBalancersResult describeLoadBalancersResult) {
		this.describeLoadBalancersResult = describeLoadBalancersResult;
	}

	/**
	 * DescribeLoadBalancersResponseのResultクラスを取得します。
	 * 
	 * @see com.nifty.cloud.sdk.Response#getResult()
	 */
	@Override
	public Result getResult() {
		return describeLoadBalancersResult;
	}

}
