/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.loadbalancer.model;

/**
 * SSLセキュリティポリシー情報クラス。<br />
 * このクラスはSSLセキュリティポリシー情報を格納します。
 */
public class Sslpolicy {

    /** SSLセキュリティポリシーID */
    private String sslPolicyId;

    /** SSLセキュリティポリシー名 */
    private String sslPolicyName;

    /**
     * SSLセキュリティポリシーIDを取得します。
     * 
     * @return SSLセキュリティポリシーID
     */
    public String getSslPolicyId() {
        return sslPolicyId;
    }

    /**
     * SSLセキュリティポリシーIDを設定します。
     * 
     * @param sslPolicyId
     *            SSLセキュリティポリシーID
     */
    public void setSslPolicyId(String sslPolicyId) {
        this.sslPolicyId = sslPolicyId;
    }

    /**
     * SSLセキュリティポリシーIDを設定し、自オブジェクトを返します。
     *
     * @param sslPolicyId
     *            SSLセキュリティポリシーID
     * @return 自オブジェクト
     */
    public Sslpolicy withSslPolicyId(String sslPolicyId) {
        setSslPolicyId(sslPolicyId);
        return this;
    }

    /**
     * SSLセキュリティポリシー名を取得します。
     * 
     * @return SSLセキュリティポリシー名
     */
    public String getSslPolicyName() {
        return sslPolicyName;
    }

    /**
     * SSLセキュリティポリシー名を設定します。
     * 
     * @param SSLPolicyName
     *            SSLセキュリティポリシー名
     */
    public void setSslPolicyName(String sslPolicyName) {
        this.sslPolicyName = sslPolicyName;
    }

    /**
     * SSLセキュリティポリシー名を設定し、自オブジェクトを返します。
     *
     * @param SSLPolicyName
     *            SSLセキュリティポリシー名
     * @return 自オブジェクト
     */
    public Sslpolicy withSslPolicyName(String sslPolicyName) {
        setSslPolicyName(sslPolicyName);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[sslPolicyId=");
        builder.append(sslPolicyId);
        builder.append(", sslPolicyName=");
        builder.append(sslPolicyName);
        builder.append("]");
        return builder.toString();
    }
}
