/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.loadbalancer.model;

/**
 * SSLセキュリティポリシーテンプレート暗号化プロトコル設定セットクラス。<br />
 * このクラスはSSLセキュリティポリシーテンプレート暗号化プロトコル設定セットを格納します。
 */
public class SSLPolicySet {

    /** SSLセキュリティポリシー暗号設定化プロトコル */
    private String cipher;

    /**
     * SSLセキュリティポリシー暗号設定化プロトコルを取得します。
     * 
     * @return SSLセキュリティポリシー暗号設定化プロトコル
     */
    public String getCipher() {
        return cipher;
    }

    /**
     * SSLセキュリティポリシー暗号設定化プロトコルを設定します。
     * 
     * @param cipher
     *            SSLセキュリティポリシー暗号設定化プロトコル
     */
    public void setCipher(String cipher) {
        this.cipher = cipher;
    }

    /**
     * SSLセキュリティポリシー暗号設定化プロトコルを設定し、自オブジェクトを返します。
     *
     * @param cipher
     *            SSLセキュリティポリシー暗号設定化プロトコル
     * @return 自オブジェクト
     */
    public SSLPolicySet withCipher(String cipher) {
        setCipher(cipher);
        return this;
    }

    /*
     * (非 Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[cipher=");
        builder.append(cipher);
        builder.append("]");
        return builder.toString();
    }

}
