/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.loadbalancer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * SSLセキュリティポリシーテンプレートセットクラス。<br />
 * このクラスはSSLセキュリティポリシーテンプレートセットを格納します。
 */
public class SSLPoliciesDescription {

    /** SSLセキュリティポリシーテンプレートId */
    private Integer sslPolicyId;

    /** SSLセキュリティポリシーテンプレート名 */
    private String sslPolicyName;

    /** SSLセキュリティポリシーテンプレート暗号化プロトコル設定セット */
    private List<SSLPolicySet> sslPolicySet;

    /**
     * SSLセキュリティポリシーテンプレートIdを取得します。
     * 
     * @return SSLセキュリティポリシーテンプレートId
     */
    public Integer getSslPolicyId() {
        return sslPolicyId;
    }

    /**
     * SSLセキュリティポリシーテンプレートIdを設定します。
     * 
     * @param sslPolicyId
     *            SSLセキュリティポリシーテンプレートId
     */
    public void setSslPolicyId(Integer sslPolicyId) {
        this.sslPolicyId = sslPolicyId;
    }

    /**
     * SSLセキュリティポリシーテンプレートIdを設定し、自オブジェクトを返します。
     *
     * @param sslPolicyId
     *            SSLセキュリティポリシーテンプレートId
     * @return 自オブジェクト
     */
    public SSLPoliciesDescription withSslPolicyId(Integer sslPolicyId) {
        setSslPolicyId(sslPolicyId);
        return this;
    }

    /**
     * SSLセキュリティポリシーテンプレート名を取得します。
     * 
     * @return SSLセキュリティポリシーテンプレート名
     */
    public String getSslPolicyName() {
        return sslPolicyName;
    }

    /**
     * SSLセキュリティポリシーテンプレート名を設定します。
     * 
     * @param sslPolicyName
     *            SSLセキュリティポリシーテンプレート名
     */
    public void setSslPolicyName(String sslPolicyName) {
        this.sslPolicyName = sslPolicyName;
    }

    /**
     * SSLセキュリティポリシーテンプレート名を設定し、自オブジェクトを返します。
     *
     * @param sslPolicyName
     *            SSLセキュリティポリシーテンプレート名
     * @return 自オブジェクト
     */
    public SSLPoliciesDescription withSslPolicyName(String sslPolicyName) {
        setSslPolicyName(sslPolicyName);
        return this;
    }

    /**
     * SSLセキュリティポリシーテンプレート暗号化プロトコル設定セットを取得します。
     * 
     * @return SSLセキュリティポリシーテンプレート暗号化プロトコル設定セット
     */
    public List<SSLPolicySet> getSslPolicySet() {
        return sslPolicySet;
    }

    /**
     * SSLセキュリティポリシーテンプレート暗号化プロトコル設定セットを設定します。
     * 
     * @param sslPolicySet
     *            SSLセキュリティポリシーテンプレート暗号化プロトコル設定セット
     */
    public void setSslPolicySet(List<SSLPolicySet> sslPolicySet) {
        this.sslPolicySet = sslPolicySet;
    }

    /**
     * SSLセキュリティポリシーテンプレート暗号化プロトコル設定セットの配列を設定し、自オブジェクトを返します。
     *
     * @param sslPolicySets
     *            SSLセキュリティポリシーテンプレート暗号化プロトコル設定セットの配列
     * @return 自オブジェクト
     */
    public SSLPoliciesDescription withSslPolicySet(SSLPolicySet... sslPolicySets) {
        if (this.sslPolicySet == null)
            this.sslPolicySet = new ArrayList<SSLPolicySet>();
        for (SSLPolicySet sslPolicySet : sslPolicySets) {
            getSslPolicySet().add(sslPolicySet);
        }
        return this;
    }

    /**
     * SSLセキュリティポリシーテンプレート暗号化プロトコル設定セットリストを設定し、自オブジェクトを返します。
     *
     * @param sslPolicySets
     *            SSLセキュリティポリシーテンプレート暗号化プロトコル設定セットリスト
     * @return 自オブジェクト
     */
    public SSLPoliciesDescription withSslPolicySet(Collection<SSLPolicySet> sslPolicySets) {
        if (this.sslPolicySet == null)
            this.sslPolicySet = new ArrayList<SSLPolicySet>();
        if (sslPolicySets != null) {
            getSslPolicySet().addAll(sslPolicySets);
        }
        return this;
    }

    /*
     * (非 Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[sslPolicyId=");
        builder.append(sslPolicyId);
        builder.append(", sslPolicyName=");
        builder.append(sslPolicyName);
        builder.append(", sslPolicySet=");
        builder.append(sslPolicySet);
        builder.append("]");
        return builder.toString();
    }

}
