/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.loadbalancer.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftySetLoadBalancerSSLPoliciesOfListenerリクエストクラス。<br />
 * このクラスはNiftySetLoadBalancerSSLPoliciesOfListenerへのリクエストを構築します。
 */
@Action("NiftySetLoadBalancerSSLPoliciesOfListener")
public class NiftySetLoadBalancerSSLPoliciesOfListenerRequest implements Request {

    /** ロードバランサー名 */
    private String loadBalancerName;

    /** 待ち受けポート */
    private Integer loadBalancerPort;

    /** 宛先ポート */
    private Integer instancePort;

    /** SSLセキュリティポリシーのテンプレートID */
    private String sslPolicyId;

    /** SSLセキュリティポリシーのテンプレート名 */
    private String sslPolicyName;

    /**
     * デフォルトコンストラクタ。
     */
    public NiftySetLoadBalancerSSLPoliciesOfListenerRequest() {
    }

    /**
     * ロードバランサー名,待ち受けポート,宛先ポートを指定し、NiftySetLoadBalancerSSLPoliciesOfListenerRequestを構築します。
     * 
     * @param loadBalancerName
     *            ロードバランサー名
     * @param loadBalancerPort
     *            待ち受けポート
     * @param instancePort
     *            宛先ポート
     */
    public NiftySetLoadBalancerSSLPoliciesOfListenerRequest(String loadBalancerName,
        Integer loadBalancerPort, Integer instancePort) {
        this.loadBalancerName = loadBalancerName;
        this.loadBalancerPort = loadBalancerPort;
        this.instancePort = instancePort;
    }

    /**
     * ロードバランサー名を取得します。
     * 
     * @return ロードバランサー名
     */
    @Query(name = "LoadBalancerName", require = true)
    public String getLoadBalancerName() {
        return loadBalancerName;
    }

    /**
     * ロードバランサー名を設定します。
     * 
     * @param loadBalancerName
     *            ロードバランサー名
     */
    public void setLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }

    /**
     * ロードバランサー名を設定し、自オブジェクトを返します。
     *
     * @param loadBalancerName
     *            ロードバランサー名
     * @return 自オブジェクト
     */
    public NiftySetLoadBalancerSSLPoliciesOfListenerRequest
        withLoadBalancerName(String loadBalancerName) {
        setLoadBalancerName(loadBalancerName);
        return this;
    }

    /**
     * 待ち受けポートを取得します。
     * 
     * @return 待ち受けポート
     */
    @Query(name = "LoadBalancerPort", require = true)
    public Integer getLoadBalancerPort() {
        return loadBalancerPort;
    }

    /**
     * 待ち受けポートを設定します。
     * 
     * @param loadBalancerPort
     *            待ち受けポート
     */
    public void setLoadBalancerPort(Integer loadBalancerPort) {
        this.loadBalancerPort = loadBalancerPort;
    }

    /**
     * 待ち受けポートを設定し、自オブジェクトを返します。
     *
     * @param loadBalancerPort
     *            待ち受けポート
     * @return 自オブジェクト
     */
    public NiftySetLoadBalancerSSLPoliciesOfListenerRequest
        withLoadBalancerPort(Integer loadBalancerPort) {
        setLoadBalancerPort(loadBalancerPort);
        return this;
    }

    /**
     * 宛先ポートを取得します。
     * 
     * @return 宛先ポート
     */
    @Query(name = "InstancePort", require = true)
    public Integer getInstancePort() {
        return instancePort;
    }

    /**
     * 宛先ポートを設定します。
     * 
     * @param instancePort
     *            宛先ポート
     */
    public void setInstancePort(Integer instancePort) {
        this.instancePort = instancePort;
    }

    /**
     * 宛先ポートを設定し、自オブジェクトを返します。
     *
     * @param instancePort
     *            宛先ポート
     * @return 自オブジェクト
     */
    public NiftySetLoadBalancerSSLPoliciesOfListenerRequest
        withInstancePort(Integer instancePort) {
        setInstancePort(instancePort);
        return this;
    }

    /**
     * SSLセキュリティポリシーのテンプレートIDを取得します。
     * 
     * @return SSLセキュリティポリシーのテンプレートID
     */
    @Query(name = "SSLPolicyId")
    public String getSslPolicyId() {
        return sslPolicyId;
    }

    /**
     * SSLセキュリティポリシーのテンプレートIDを設定します。
     * 
     * @param sslPolicyId
     *            SSLセキュリティポリシーのテンプレートID
     */
    public void setSslPolicyId(String sslPolicyId) {
        this.sslPolicyId = sslPolicyId;
    }

    /**
     * SSLセキュリティポリシーのテンプレートIDを設定し、自オブジェクトを返します。
     *
     * @param sslPolicyId
     *            SSLセキュリティポリシーのテンプレートID
     * @return 自オブジェクト
     */
    public NiftySetLoadBalancerSSLPoliciesOfListenerRequest
        withSslPolicyId(String sslPolicyId) {
        setSslPolicyId(sslPolicyId);
        return this;
    }

    /**
     * SSLセキュリティポリシーのテンプレート名を取得します。
     * 
     * @return SSLセキュリティポリシーのテンプレート名
     */
    @Query(name = "SSLPolicyName")
    public String getSslPolicyName() {
        return sslPolicyName;
    }

    /**
     * SSLセキュリティポリシーのテンプレート名を設定します。
     * 
     * @param sslPolicyName
     *            SSLセキュリティポリシーのテンプレート名
     */
    public void setSslPolicyName(String sslPolicyName) {
        this.sslPolicyName = sslPolicyName;
    }

    /**
     * SSLセキュリティポリシーのテンプレート名を設定し、自オブジェクトを返します。
     *
     * @param sslPolicyName
     *            SSLセキュリティポリシーのテンプレート名
     * @return 自オブジェクト
     */
    public NiftySetLoadBalancerSSLPoliciesOfListenerRequest
        withSslPolicyName(String sslPolicyName) {
        setSslPolicyName(sslPolicyName);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[loadBalancerName=");
        builder.append(loadBalancerName);
        builder.append(", loadBalancerPort=");
        builder.append(loadBalancerPort);
        builder.append(", instancePort=");
        builder.append(instancePort);
        builder.append(", sslPolicyId=");
        builder.append(sslPolicyId);
        builder.append(", sslPolicyName=");
        builder.append(sslPolicyName);
        builder.append("]");
        return builder.toString();
    }

}
