/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.loadbalancer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.annotation.Xml2Response;
import com.nifty.cloud.sdk.loadbalancer.model.transform.NiftyDescribeLoadBalancerSSLPoliciesResponse;
import com.nifty.cloud.sdk.loadbalancer.model.transform.SSLPoliciesDescriptionsConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * NiftyDescribeLoadBalancerSSLPolicies結果処理クラス。<br />
 * このクラスはNiftyDescribeLoadBalancerSSLPoliciesのレスポンスを格納します。
 */
@Xml2Response(response = NiftyDescribeLoadBalancerSSLPoliciesResponse.class)
public class NiftyDescribeLoadBalancerSSLPoliciesResult extends Result {

    /** ロードバランサー名 */
    @XStreamAlias("LoadBalancerName")
    private String loadBalancerName;

    /** SSLセキュリティポリシーテンプレートセット */
    @XStreamAlias("SSLPoliciesDescriptions")
    @XStreamConverter(SSLPoliciesDescriptionsConverter.class)
    private List<SSLPoliciesDescription> sslPoliciesDescriptions;

    /**
     * ロードバランサー名を取得します。
     * 
     * @return ロードバランサー名
     */
    public String getLoadBalancerName() {
        return loadBalancerName;
    }

    /**
     * ロードバランサー名を設定します。
     * 
     * @param loadBalancerName
     *            ロードバランサー名
     */
    public void setLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }

    /**
     * ロードバランサー名を設定し、自オブジェクトを返します。
     *
     * @param loadBalancerName
     *            ロードバランサー名
     * @return 自オブジェクト
     */
    public NiftyDescribeLoadBalancerSSLPoliciesResult
        withLoadBalancerName(String loadBalancerName) {
        setLoadBalancerName(loadBalancerName);
        return this;
    }

    /**
     * SSLセキュリティポリシーテンプレートセットを取得します。
     * 
     * @return SSLセキュリティポリシーテンプレートセット
     */
    public List<SSLPoliciesDescription> getSSLPoliciesDescriptions() {
        return sslPoliciesDescriptions;
    }

    /**
     * SSLセキュリティポリシーテンプレートセットを設定します。
     * 
     * @param sslPoliciesDescriptions
     *            SSLセキュリティポリシーテンプレートセット
     */
    public void setSSLPoliciesDescriptions(List<SSLPoliciesDescription> sslPoliciesDescriptions) {
        this.sslPoliciesDescriptions = sslPoliciesDescriptions;
    }

    /**
     * SSLセキュリティポリシーテンプレートセットの配列を設定し、自オブジェクトを返します。
     *
     * @param sslPoliciesDescriptions
     *            SSLセキュリティポリシーテンプレートセットの配列
     * @return 自オブジェクト
     */
    public NiftyDescribeLoadBalancerSSLPoliciesResult
        withSSLPoliciesDescriptions(SSLPoliciesDescription... sslPoliciesDescriptions) {
        if (this.sslPoliciesDescriptions == null)
            this.sslPoliciesDescriptions = new ArrayList<SSLPoliciesDescription>();
        for (SSLPoliciesDescription sslPoliciesDescription : sslPoliciesDescriptions) {
            getSSLPoliciesDescriptions().add(sslPoliciesDescription);
        }
        return this;
    }

    /**
     * SSLセキュリティポリシーテンプレートセットを設定し、自オブジェクトを返します。
     *
     * @param sslPoliciesDescriptions
     *            SSLセキュリティポリシーテンプレートセット
     * @return 自オブジェクト
     */
    public NiftyDescribeLoadBalancerSSLPoliciesResult
        withSSLPoliciesDescriptions(Collection<SSLPoliciesDescription> sslPoliciesDescriptions) {
        if (this.sslPoliciesDescriptions == null)
            this.sslPoliciesDescriptions = new ArrayList<SSLPoliciesDescription>();
        if (sslPoliciesDescriptions != null) {
            getSSLPoliciesDescriptions().addAll(sslPoliciesDescriptions);
        }
        return this;
    }

    /*
     * (非 Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[loadBalancerName=");
        builder.append(loadBalancerName);
        builder.append(", sslPoliciesDescriptions=");
        builder.append(sslPoliciesDescriptions);
        builder.append("]");
        return builder.toString();
    }

}
