/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.loadbalancer.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyDescribeLoadBalancerSSLPoliciesリクエストクラス。<br />
 * このクラスはNiftyDescribeLoadBalancerSSLPoliciesへのリクエストを構築します。
 */
@Action("NiftyDescribeLoadBalancerSSLPolicies")
public class NiftyDescribeLoadBalancerSSLPoliciesRequest implements Request {

    /** ロードバランサー名 */
    private String loadBalancerName;

    /**
     * デフォルトコンストラクタ。
     */
    public NiftyDescribeLoadBalancerSSLPoliciesRequest() {
    }

    /**
     * ロードバランサー名を指定し、NiftyDescribeLoadBalancerSSLPoliciesRequestを構築します。
     * 
     * @param loadBalancerName
     *            ロードバランサー名
     */
    public NiftyDescribeLoadBalancerSSLPoliciesRequest(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }

    /**
     * ロードバランサー名を取得します。
     * 
     * @return ロードバランサー名
     */
    @Query(name = "LoadBalancerName", require = true)
    public String getLoadBalancerName() {
        return loadBalancerName;
    }

    /**
     * ロードバランサー名を設定します。
     * 
     * @param loadBalancerName
     *            ロードバランサー名
     */
    public void setLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }

    /**
     * ロードバランサー名を設定し、自オブジェクトを返します。
     *
     * @param loadBalancerName
     *            ロードバランサー名
     * @return 自オブジェクト
     */
    public NiftyDescribeLoadBalancerSSLPoliciesRequest
        withLoadBalancerName(String loadBalancerName) {
        setLoadBalancerName(loadBalancerName);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[loadBalancerName=");
        builder.append(loadBalancerName);
        builder.append("]");
        return builder.toString();
    }

}
