/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.loadbalancer;

import com.nifty.cloud.sdk.BaseClient;
import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.loadbalancer.model.ClearLoadBalancerSessionRequest;
import com.nifty.cloud.sdk.loadbalancer.model.ClearLoadBalancerSessionResult;
import com.nifty.cloud.sdk.loadbalancer.model.ConfigureHealthCheckRequest;
import com.nifty.cloud.sdk.loadbalancer.model.ConfigureHealthCheckResult;
import com.nifty.cloud.sdk.loadbalancer.model.CreateLoadBalancerRequest;
import com.nifty.cloud.sdk.loadbalancer.model.CreateLoadBalancerResult;
import com.nifty.cloud.sdk.loadbalancer.model.DeleteLoadBalancerRequest;
import com.nifty.cloud.sdk.loadbalancer.model.DeleteLoadBalancerResult;
import com.nifty.cloud.sdk.loadbalancer.model.DeregisterInstancesFromLoadBalancerRequest;
import com.nifty.cloud.sdk.loadbalancer.model.DeregisterInstancesFromLoadBalancerResult;
import com.nifty.cloud.sdk.loadbalancer.model.DescribeInstanceHealthRequest;
import com.nifty.cloud.sdk.loadbalancer.model.DescribeInstanceHealthResult;
import com.nifty.cloud.sdk.loadbalancer.model.DescribeLoadBalancersRequest;
import com.nifty.cloud.sdk.loadbalancer.model.DescribeLoadBalancersResult;
import com.nifty.cloud.sdk.loadbalancer.model.NiftyDescribeLoadBalancerSSLPoliciesRequest;
import com.nifty.cloud.sdk.loadbalancer.model.NiftyDescribeLoadBalancerSSLPoliciesResult;
import com.nifty.cloud.sdk.loadbalancer.model.NiftySetLoadBalancerSSLPoliciesOfListenerRequest;
import com.nifty.cloud.sdk.loadbalancer.model.NiftySetLoadBalancerSSLPoliciesOfListenerResult;
import com.nifty.cloud.sdk.loadbalancer.model.NiftyUnSetLoadBalancerSSLPoliciesOfListenerRequest;
import com.nifty.cloud.sdk.loadbalancer.model.NiftyUnSetLoadBalancerSSLPoliciesOfListenerResult;
import com.nifty.cloud.sdk.loadbalancer.model.RegisterInstancesWithLoadBalancerRequest;
import com.nifty.cloud.sdk.loadbalancer.model.RegisterInstancesWithLoadBalancerResult;
import com.nifty.cloud.sdk.loadbalancer.model.RegisterPortWithLoadBalancerRequest;
import com.nifty.cloud.sdk.loadbalancer.model.RegisterPortWithLoadBalancerResult;
import com.nifty.cloud.sdk.loadbalancer.model.SetFilterForLoadBalancerRequest;
import com.nifty.cloud.sdk.loadbalancer.model.SetFilterForLoadBalancerResult;
import com.nifty.cloud.sdk.loadbalancer.model.SetLoadBalancerListenerSSLCertificateRequest;
import com.nifty.cloud.sdk.loadbalancer.model.SetLoadBalancerListenerSSLCertificateResult;
import com.nifty.cloud.sdk.loadbalancer.model.UnsetLoadBalancerListenerSSLCertificateRequest;
import com.nifty.cloud.sdk.loadbalancer.model.UnsetLoadBalancerListenerSSLCertificateResult;
import com.nifty.cloud.sdk.loadbalancer.model.UpdateLoadBalancerOptionRequest;
import com.nifty.cloud.sdk.loadbalancer.model.UpdateLoadBalancerOptionResult;
import com.nifty.cloud.sdk.loadbalancer.model.UpdateLoadBalancerRequest;
import com.nifty.cloud.sdk.loadbalancer.model.UpdateLoadBalancerResult;

/**
 * NIFCLOUD API クライアント 具象クラス。 ネットワークカテゴリ クライアント。<br />
 * ネットワークカテゴリの同期クライアントの具象クラスです。<br />
 * 戻り値の"利用不可"パラメータは返却値がnullまたは空となります。
 */
public class NiftyLoadBalancerClient extends BaseClient implements NiftyLoadBalancer {

    /**
     * 認証情報を指定し、ネットワークカテゴリクライアントを構築します。
     * 
     * @param credential
     *            認証情報
     */
    public NiftyLoadBalancerClient(Credentials credential) {
        super(credential, new ClientConfiguration());
    }

    /**
     * 認証情報、クライアント設定を指定し、ネットワークカテゴリクライアントを構築します。
     * 
     * @param credential
     *            認証情報
     * @param configuration
     *            クライアント設定
     */
    public NiftyLoadBalancerClient(Credentials credential, ClientConfiguration configuration) {
        super(credential, configuration);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CreateLoadBalancerResult createLoadBalancer(CreateLoadBalancerRequest request) {
        return (CreateLoadBalancerResult) client.execute(request, CreateLoadBalancerResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ConfigureHealthCheckResult configureHealthCheck(ConfigureHealthCheckRequest request) {
        return (ConfigureHealthCheckResult) client.execute(request,
            ConfigureHealthCheckResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeleteLoadBalancerResult deleteLoadBalancer(DeleteLoadBalancerRequest request) {
        return (DeleteLoadBalancerResult) client.execute(request, DeleteLoadBalancerResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeregisterInstancesFromLoadBalancerResult
        deregisterInstancesFromLoadBalancer(DeregisterInstancesFromLoadBalancerRequest request) {
        return (DeregisterInstancesFromLoadBalancerResult) client.execute(request,
            DeregisterInstancesFromLoadBalancerResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DescribeInstanceHealthResult
        describeInstanceHealth(DescribeInstanceHealthRequest request) {
        return (DescribeInstanceHealthResult) client.execute(request,
            DescribeInstanceHealthResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DescribeLoadBalancersResult describeLoadBalancers(DescribeLoadBalancersRequest request) {
        return (DescribeLoadBalancersResult) client.execute(request,
            DescribeLoadBalancersResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RegisterInstancesWithLoadBalancerResult
        registerInstancesWithLoadBalancer(RegisterInstancesWithLoadBalancerRequest request) {
        return (RegisterInstancesWithLoadBalancerResult) client.execute(request,
            RegisterInstancesWithLoadBalancerResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RegisterPortWithLoadBalancerResult
        registerPortWithLoadBalancer(RegisterPortWithLoadBalancerRequest request) {
        return (RegisterPortWithLoadBalancerResult) client.execute(request,
            RegisterPortWithLoadBalancerResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SetFilterForLoadBalancerResult
        setFilterForLoadBalancer(SetFilterForLoadBalancerRequest request) {
        return (SetFilterForLoadBalancerResult) client.execute(request,
            SetFilterForLoadBalancerResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public UpdateLoadBalancerResult updateLoadBalancer(UpdateLoadBalancerRequest request) {
        return (UpdateLoadBalancerResult) client.execute(request, UpdateLoadBalancerResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public UpdateLoadBalancerOptionResult
        updateLoadBalancerOption(UpdateLoadBalancerOptionRequest request) {
        return (UpdateLoadBalancerOptionResult) client.execute(request,
            UpdateLoadBalancerOptionResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SetLoadBalancerListenerSSLCertificateResult setLoadBalancerListenerSSLCertificate(
        SetLoadBalancerListenerSSLCertificateRequest request) {
        return (SetLoadBalancerListenerSSLCertificateResult) client.execute(request,
            SetLoadBalancerListenerSSLCertificateResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public UnsetLoadBalancerListenerSSLCertificateResult unsetLoadBalancerListenerSSLCertificate(
        UnsetLoadBalancerListenerSSLCertificateRequest request) {
        return (UnsetLoadBalancerListenerSSLCertificateResult) client.execute(request,
            UnsetLoadBalancerListenerSSLCertificateResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ClearLoadBalancerSessionResult
        clearLoadBalancerSession(ClearLoadBalancerSessionRequest request) {
        return (ClearLoadBalancerSessionResult) client.execute(request,
            ClearLoadBalancerSessionResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftySetLoadBalancerSSLPoliciesOfListenerResult
        niftySetLoadBalancerSSLPoliciesOfListener(
            NiftySetLoadBalancerSSLPoliciesOfListenerRequest request) {
        return (NiftySetLoadBalancerSSLPoliciesOfListenerResult) client.execute(request,
            NiftySetLoadBalancerSSLPoliciesOfListenerResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyUnSetLoadBalancerSSLPoliciesOfListenerResult
        niftyUnSetLoadBalancerSSLPoliciesOfListener(
            NiftyUnSetLoadBalancerSSLPoliciesOfListenerRequest request) {
        return (NiftyUnSetLoadBalancerSSLPoliciesOfListenerResult) client.execute(request,
            NiftyUnSetLoadBalancerSSLPoliciesOfListenerResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyDescribeLoadBalancerSSLPoliciesResult
        niftyDescribeLoadBalancerSSLPolicies(
            NiftyDescribeLoadBalancerSSLPoliciesRequest request) {
        return (NiftyDescribeLoadBalancerSSLPoliciesResult) client.execute(request,
            NiftyDescribeLoadBalancerSSLPoliciesResult.class);
    }
}
