/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.firewall.model.transform;

import java.util.ArrayList;
import java.util.List;

import com.nifty.cloud.sdk.firewall.model.VpnGatewayNetworkInterface;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * VpnGatewayNetworkInterfaceSetType変換クラス。<br />
 * このクラスはレスポンスXMLのvpnGatewayNetworkInterfaceSet要素からVpnGatewayNetworkInterfaceクラスのリストを生成します。
 */

public class VpnGatewayNetworkInterfaceConverter implements Converter {

	private static final String ELEMENT_VPN_GATEWAY_ID = "vpnGatewayId";
	private static final String ELEMENT_NIFTY_VPN_GATEWAY_NAME = "niftyVpnGatewayName";
	private static final String ELEMENT_NETWORK_ID = "networkId";
	private static final String ELEMENT_DEVICE_INDEX = "deviceIndex";
	private static final String ELEMENT_IP_ADDRESS = "ipAddress";

	/**
	 * 変換可能なクラスか判定します。
	 *
	 * @param clazz クラス
	 * @return 変換可能な場合true, 変換不可能な場合false
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
	 */
	@SuppressWarnings("rawtypes")
	@Override
	public boolean canConvert(Class clazz) {
		Class[] interfaces = clazz.getInterfaces();
		for (Class i : interfaces) {
			if (i == List.class) {
				return true;
			}
		}
		return false;
	}

	/**
	 * {@literal
	 * vpnGatewayNetworkInterfaceSetをList<VpnGatewayNetworkInterface>クラスに変換します。}
	 *
	 * @param reader XML読込リーダ
	 * @param context
	 * @return {@literal List<VpnGatewayNetworkInterface>オブジェクト}
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader,
	 *      UnmarshallingContext)
	 */
	@Override
	public Object unmarshal(HierarchicalStreamReader reader,
			UnmarshallingContext context) {
		List<VpnGatewayNetworkInterface> vpnGatewayNetworkInterfaces = new ArrayList<VpnGatewayNetworkInterface>();
		String name = null;
		while (reader.hasMoreChildren()) {
			reader.moveDown();
			VpnGatewayNetworkInterface vpnGatewayNetworkInterface = new VpnGatewayNetworkInterface();

			while (reader.hasMoreChildren()) {
				reader.moveDown();

				name = reader.getNodeName();
				if (name.equals(ELEMENT_VPN_GATEWAY_ID)) {
					vpnGatewayNetworkInterface.setVpnGatewayId(reader.getValue());
				} else if (name.equals(ELEMENT_NIFTY_VPN_GATEWAY_NAME)) {
					vpnGatewayNetworkInterface.setNiftyVpnGatewayName(reader.getValue());
				} else if (name.equals(ELEMENT_NETWORK_ID)) {
					vpnGatewayNetworkInterface.setNetworkId(reader.getValue());
				} else if (name.equals(ELEMENT_DEVICE_INDEX)) {
					vpnGatewayNetworkInterface.setDeviceIndex(reader.getValue());
				} else if (name.equals(ELEMENT_IP_ADDRESS)) {
					vpnGatewayNetworkInterface.setIpAddress(reader.getValue());
				}

				reader.moveUp();
			}
			reader.moveUp();
			vpnGatewayNetworkInterfaces.add(vpnGatewayNetworkInterface);
		}
		return vpnGatewayNetworkInterfaces;
	}

	/**
	 * 未実装メソッド
	 */
	@Override
	public void marshal(Object paramObject,
			HierarchicalStreamWriter paramHierarchicalStreamWriter,
			MarshallingContext paramMarshallingContext) {
	}
}