/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.firewall.model;

/**
 *
 * ネットワークインターフェイスごとにファイアウォール適用しているVPNゲートウェイ情報クラス。<br />
 * このクラスはネットワークインターフェイスごとにファイアウォール適用しているVPNゲートウェイ情報を格納します。
 *
 */
public class VpnGatewayNetworkInterface {

	/** VPNゲートウェイユニークID */
	private String vpnGatewayId;

	/** VPNゲートウェイ名 */
	private String niftyVpnGatewayName;

	/** ネットワークユニークID */
	private String networkId;

	/** デバイス番号 */
	private String deviceIndex;

	/** IPアドレス */
	private String ipAddress;


	/**
	 * VPNゲートウェイユニークIDを取得します。
	 *
	 * @return VPNゲートウェイユニークID
	 */
	public String getVpnGatewayId() {
		return vpnGatewayId;
	}

	/**
	 * VPNゲートウェイユニークIDを設定します。
	 *
	 * @param vpnGatewayId VPNゲートウェイユニークID
	 */
	public void setVpnGatewayId(String vpnGatewayId) {
		this.vpnGatewayId = vpnGatewayId;
	}

	/**
	 * VPNゲートウェイユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param vpnGatewayId VPNゲートウェイユニークID
	 * @return 自オブジェクト
	 */
	public VpnGatewayNetworkInterface withVpnGatewayId(String vpnGatewayId) {
		setVpnGatewayId(vpnGatewayId);
		return this;
	}

	/**
	 * VPNゲートウェイ名を取得します。
	 *
	 * @return VPNゲートウェイ名
	 */
	public String getNiftyVpnGatewayName() {
		return niftyVpnGatewayName;
	}

	/**
	 * VPNゲートウェイ名を設定します。
	 *
	 * @param niftyVpnGatewayName VPNゲートウェイ名
	 */
	public void setNiftyVpnGatewayName(String niftyVpnGatewayName) {
		this.niftyVpnGatewayName = niftyVpnGatewayName;
	}

	/**
	 * VPNゲートウェイ名を設定し、自オブジェクトを返します。
	 *
	 * @param niftyVpnGatewayName VPNゲートウェイ名
	 * @return 自オブジェクト
	 */
	public VpnGatewayNetworkInterface withNiftyVpnGatewayName(String niftyVpnGatewayName) {
		setNiftyVpnGatewayName(niftyVpnGatewayName);
		return this;
	}

	/**
	 * ネットワークユニークIDを取得します。
	 *
	 * @return ネットワークユニークID
	 */
	public String getNetworkId() {
		return networkId;
	}

	/**
	 * ネットワークユニークIDを設定します。
	 *
	 * @param networkId ネットワークユニークID
	 */
	public void setNetworkId(String networkId) {
		this.networkId = networkId;
	}

	/**
	 * ネットワークユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param networkId ネットワークユニークID
	 * @return 自オブジェクト
	 */
	public VpnGatewayNetworkInterface withNetworkId(String networkId) {
		setNetworkId(networkId);
		return this;
	}

	/**
	 * デバイス番号を取得します。
	 *
	 * @return デバイス番号
	 */
	public String getDeviceIndex() {
		return deviceIndex;
	}

	/**
	 * デバイス番号を設定します。
	 *
	 * @param deviceIndex デバイス番号
	 */
	public void setDeviceIndex(String deviceIndex) {
		this.deviceIndex = deviceIndex;
	}

	/**
	 * デバイス番号を設定し、自オブジェクトを返します。
	 *
	 * @param deviceIndex デバイス番号
	 * @return 自オブジェクト
	 */
	public VpnGatewayNetworkInterface withDeviceIndex(String deviceIndex) {
		setDeviceIndex(deviceIndex);
		return this;
	}
	/**
	 * IPアドレスを取得します。
	 *
	 * @return IPアドレス
	 */
	public String getIpAddress() {
		return ipAddress;
	}

	/**
	 * IPアドレスを設定します。
	 *
	 * @param ipAddress IPアドレス
	 */
	public void setIpAddress(String ipAddress) {
		this.ipAddress = ipAddress;
	}

	/**
	 * IPアドレスを設定し、自オブジェクトを返します。
	 *
	 * @param ipAddress IPアドレス
	 * @return 自オブジェクト
	 */
	public VpnGatewayNetworkInterface withIpAddress(String ipAddress) {
		setIpAddress(ipAddress);
		return this;
	}


	/*
	 * (non-Javadoc)
	 *
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[vpnGatewayId=");
		builder.append(vpnGatewayId);
		builder.append(", niftyVpnGatewayName=");
		builder.append(niftyVpnGatewayName);
		builder.append(", networkId=");
		builder.append(networkId);
		builder.append(", deviceIndex=");
		builder.append(deviceIndex);
		builder.append(", ipAddress=");
		builder.append(ipAddress);
		builder.append("]");
		return builder.toString();
	}
}
