/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.firewall.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyRegisterVpnGatewaysWithSecurityGroupリクエストクラス。<br />
 * このクラスはNiftyRegisterVpnGatewaysWithSecurityGroupへのリクエストを構築します。
 *
 */
@Action("NiftyRegisterVpnGatewaysWithSecurityGroup")
public class NiftyRegisterVpnGatewaysWithSecurityGroupRequest implements Request {

	/** ファイアウォールグループ名 */
	private String groupName;

	/** VPNゲートウェイ情報 */
	private List<VpnGatewayIdSet> vpnGateways;

	/**
	 * デフォルトコンストラクタ。
	 */
	public NiftyRegisterVpnGatewaysWithSecurityGroupRequest() {
	}

	/**
	 * ファイアウォールグループ名,VPNゲートウェイ情報を指定し、NiftyRegisterVpnGatewaysWithSecurityGroupRequestを構築します。
	 *
	 * @param groupName ファイアウォールグループ名
	 * @param vpnGateways VPNゲートウェイ情報
	 */
	public NiftyRegisterVpnGatewaysWithSecurityGroupRequest(String groupName, List<VpnGatewayIdSet> vpnGateways) {
		this.groupName = groupName;
		this.vpnGateways = vpnGateways;
	}

	/**
	 * ファイアウォールグループ名を取得します。
	 *
	 * @return ファイアウォールグループ名
	 */
	@Query(name="GroupName", require=true)
	public String getGroupName() {
		return groupName;
	}

	/**
	 * ファイアウォールグループ名を設定します。
	 *
	 * @param groupName ファイアウォールグループ名
	 */
	public void setGroupName(String groupName) {
		this.groupName = groupName;
	}

	/**
	 * ファイアウォールグループ名を設定し、自オブジェクトを返します。
	 *
	 * @param groupName ファイアウォールグループ名
	 * @return 自オブジェクト
	 */
	public NiftyRegisterVpnGatewaysWithSecurityGroupRequest withGroupName(String groupName) {
		setGroupName(groupName);
		return this;
	}

	/**
	 * VPNゲートウェイ情報を取得します。
	 *
	 * @return VPNゲートウェイ情報
	 */
	@Query(name="VpnGatewaySet", require=true)
	public List<VpnGatewayIdSet> getVpnGateways() {
		return vpnGateways;
	}

	/**
	 * VPNゲートウェイ情報を設定します。
	 *
	 * @param vpnGateways VPNゲートウェイ情報
	 */
	public void setVpnGateways(List<VpnGatewayIdSet> vpnGateways) {
		this.vpnGateways = vpnGateways;
	}

	/**
	 * VPNゲートウェイ情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param vpnGateways VPNゲートウェイ情報の配列
	 * @return 自オブジェクト
	 */
	public NiftyRegisterVpnGatewaysWithSecurityGroupRequest withVpnGateways(VpnGatewayIdSet ... vpnGateways) {
		if (this.vpnGateways == null) this.vpnGateways = new ArrayList<VpnGatewayIdSet>();
		for (VpnGatewayIdSet vpnGateway : vpnGateways) {
			getVpnGateways().add(vpnGateway);
		}
		return this;
	}

	/**
	 * VPNゲートウェイ情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param vpnGateways VPNゲートウェイ情報リスト
	 * @return 自オブジェクト
	 */
	public NiftyRegisterVpnGatewaysWithSecurityGroupRequest withVpnGateways(Collection<VpnGatewayIdSet> vpnGateways) {
		if (this.vpnGateways == null) this.vpnGateways = new ArrayList<VpnGatewayIdSet>();
		if (vpnGateways != null) {
			getVpnGateways().addAll(vpnGateways);
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[groupName=");
		builder.append(groupName);
		builder.append(", vpnGateways=");
		builder.append(vpnGateways);
		builder.append("]");
		return builder.toString();
	}
}
