/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.firewall.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.firewall.model.transform.NiftyRegisterRoutersWithSecurityGroupResultConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * NiftyRegisterRoutersWithSecurityGroup処理結果クラス。<br />
 * このクラスはNiftyRegisterRoutersWithSecurityGroupのレスポンスを格納します。
 */
@XStreamAlias("NiftyRegisterRoutersWithSecurityGroupResponse")
@XStreamConverter(NiftyRegisterRoutersWithSecurityGroupResultConverter.class)
public class NiftyRegisterRoutersWithSecurityGroupResult extends Result {

	/** リクエスト識別子 */
	private String requestId;

	/** 適用に成功したルーターの情報 */
	private List<RouterIdSet> routers;

	/**
	 * リクエスト識別子を取得します。
	 *
	 * @return リクエスト識別子
	 */
	public String getRequestId() {
		return requestId;
	}

	/**
	 * リクエスト識別子を設定します。
	 *
	 * @param requestId リクエスト識別子
	 */
	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	/**
	 * リクエスト識別子を設定し、自オブジェクトを返します。
	 *
	 * @param requestId リクエスト識別子
	 * @return 自オブジェクト
	 */
	public NiftyRegisterRoutersWithSecurityGroupResult withRequestId(String requestId) {
		setRequestId(requestId);
		return this;
	}

	/**
	 * 適用に成功したルーターの情報を取得します。
	 *
	 * @return 適用に成功したルーターの情報
	 */
	public List<RouterIdSet> getRouters() {
		return routers;
	}

	/**
	 * 適用に成功したルーターの情報を設定します。
	 *
	 * @param routers 適用に成功したルーターの情報
	 */
	public void setRouters(List<RouterIdSet> routers) {
		this.routers = routers;
	}

	/**
	 * 適用に成功したルーターの情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param routers 適用に成功したルーターの情報の配列
	 * @return 自オブジェクト
	 */
	public NiftyRegisterRoutersWithSecurityGroupResult withRouters(RouterIdSet ... routers) {
		if (this.routers == null) this.routers = new ArrayList<RouterIdSet>();
		for (RouterIdSet router : routers) {
			getRouters().add(router);
		}
		return this;
	}

	/**
	 * 適用に成功したルーターの情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param routers 適用に成功したルーターの情報リスト
	 * @return 自オブジェクト
	 */
	public NiftyRegisterRoutersWithSecurityGroupResult withRouters(Collection<RouterIdSet> routers) {
		if (this.routers == null) this.routers = new ArrayList<RouterIdSet>();
		if (routers != null) {
			getRouters().addAll(routers);
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[requestId=");
		builder.append(requestId);
		builder.append(", routers=");
		builder.append(routers);
		builder.append("]");
		return builder.toString();
	}
}
