/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.firewall.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.firewall.model.transform.NiftyDeregisterVpnGatewaysFromSecurityGroupResultConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * NiftyDeregisterVpnGatewaysFromSecurityGroup処理結果クラス。<br />
 * このクラスはNiftyDeregisterVpnGatewaysFromSecurityGroupのレスポンスを格納します。
 */
@XStreamAlias("NiftyDeregisterVpnGatewaysFromSecurityGroupResponse")
@XStreamConverter(NiftyDeregisterVpnGatewaysFromSecurityGroupResultConverter.class)
public class NiftyDeregisterVpnGatewaysFromSecurityGroupResult extends Result {

	/** リクエスト識別子 */
	private String requestId;

	/** 解除に成功したVPNゲートウェイの情報 */
	private List<VpnGatewayIdSet> vpnGateways;

	/**
	 * リクエスト識別子を取得します。
	 *
	 * @return リクエスト識別子
	 */
	public String getRequestId() {
		return requestId;
	}

	/**
	 * リクエスト識別子を設定します。
	 *
	 * @param requestId リクエスト識別子
	 */
	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	/**
	 * リクエスト識別子を設定し、自オブジェクトを返します。
	 *
	 * @param requestId リクエスト識別子
	 * @return 自オブジェクト
	 */
	public NiftyDeregisterVpnGatewaysFromSecurityGroupResult withRequestId(String requestId) {
		setRequestId(requestId);
		return this;
	}

	/**
	 * 解除に成功したVPNゲートウェイの情報を取得します。
	 *
	 * @return 解除に成功したVPNゲートウェイの情報
	 */
	public List<VpnGatewayIdSet> getVpnGateways() {
		return vpnGateways;
	}

	/**
	 * 解除に成功したVPNゲートウェイの情報を設定します。
	 *
	 * @param vpnGateways 解除に成功したVPNゲートウェイの情報
	 */
	public void setVpnGateways(List<VpnGatewayIdSet> vpnGateways) {
		this.vpnGateways = vpnGateways;
	}

	/**
	 * 解除に成功したVPNゲートウェイの情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param vpnGateways 解除に成功したVPNゲートウェイの情報の配列
	 * @return 自オブジェクト
	 */
	public NiftyDeregisterVpnGatewaysFromSecurityGroupResult withVpnGateways(VpnGatewayIdSet ... vpnGateways) {
		if (this.vpnGateways == null) this.vpnGateways = new ArrayList<VpnGatewayIdSet>();
		for (VpnGatewayIdSet vpnGateway : vpnGateways) {
			getVpnGateways().add(vpnGateway);
		}
		return this;
	}

	/**
	 * 解除に成功したVPNゲートウェイの情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param vpnGateways 解除に成功したVPNゲートウェイの情報リスト
	 * @return 自オブジェクト
	 */
	public NiftyDeregisterVpnGatewaysFromSecurityGroupResult withVpnGateways(Collection<VpnGatewayIdSet> vpnGateways) {
		if (this.vpnGateways == null) this.vpnGateways = new ArrayList<VpnGatewayIdSet>();
		if (vpnGateways != null) {
			getVpnGateways().addAll(vpnGateways);
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[requestId=");
		builder.append(requestId);
		builder.append(", vpnGateways=");
		builder.append(vpnGateways);
		builder.append("]");
		return builder.toString();
	}
}
