/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.firewall;


import com.nifty.cloud.sdk.BaseClient;
import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.firewall.model.AuthorizeSecurityGroupIngressRequest;
import com.nifty.cloud.sdk.firewall.model.AuthorizeSecurityGroupIngressResult;
import com.nifty.cloud.sdk.firewall.model.CreateSecurityGroupRequest;
import com.nifty.cloud.sdk.firewall.model.CreateSecurityGroupResult;
import com.nifty.cloud.sdk.firewall.model.DeleteSecurityGroupRequest;
import com.nifty.cloud.sdk.firewall.model.DeleteSecurityGroupResult;
import com.nifty.cloud.sdk.firewall.model.DeregisterInstancesFromSecurityGroupRequest;
import com.nifty.cloud.sdk.firewall.model.DeregisterInstancesFromSecurityGroupResult;
import com.nifty.cloud.sdk.firewall.model.DescribeSecurityActivitiesRequest;
import com.nifty.cloud.sdk.firewall.model.DescribeSecurityActivitiesResult;
import com.nifty.cloud.sdk.firewall.model.DescribeSecurityGroupsRequest;
import com.nifty.cloud.sdk.firewall.model.DescribeSecurityGroupsResult;
import com.nifty.cloud.sdk.firewall.model.NiftyDeregisterRoutersFromSecurityGroupRequest;
import com.nifty.cloud.sdk.firewall.model.NiftyDeregisterRoutersFromSecurityGroupResult;
import com.nifty.cloud.sdk.firewall.model.NiftyDeregisterVpnGatewaysFromSecurityGroupRequest;
import com.nifty.cloud.sdk.firewall.model.NiftyDeregisterVpnGatewaysFromSecurityGroupResult;
import com.nifty.cloud.sdk.firewall.model.NiftyRegisterRoutersWithSecurityGroupRequest;
import com.nifty.cloud.sdk.firewall.model.NiftyRegisterRoutersWithSecurityGroupResult;
import com.nifty.cloud.sdk.firewall.model.NiftyRegisterVpnGatewaysWithSecurityGroupRequest;
import com.nifty.cloud.sdk.firewall.model.NiftyRegisterVpnGatewaysWithSecurityGroupResult;
import com.nifty.cloud.sdk.firewall.model.RegisterInstancesWithSecurityGroupRequest;
import com.nifty.cloud.sdk.firewall.model.RegisterInstancesWithSecurityGroupResult;
import com.nifty.cloud.sdk.firewall.model.RevokeSecurityGroupIngressRequest;
import com.nifty.cloud.sdk.firewall.model.RevokeSecurityGroupIngressResult;
import com.nifty.cloud.sdk.firewall.model.UpdateSecurityGroupRequest;
import com.nifty.cloud.sdk.firewall.model.UpdateSecurityGroupResult;

/**
 * NIFCLOUD API クライアント　具象クラス。
 * ファイアウォールカテゴリ クライアント。<br />
 * ファイアウォールカテゴリの同期クライアントの具象クラスです。<br />
 * 戻り値の"利用不可"パラメータは返却値がnullまたは空となります。
 *
 */
public class NiftySecurityGroupClient extends BaseClient implements NiftySecurityGroup {

	/**
	 * 認証情報を指定し、ファイアウォールカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 */
	public NiftySecurityGroupClient(Credentials credential) {
		super(credential, new ClientConfiguration());
	}

	/**
	 * 認証情報、クライアント設定を指定し、ファイアウォールカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 * @param configuration クライアント設定
	 */
	public NiftySecurityGroupClient(Credentials credential, ClientConfiguration configuration) {
		super(credential, configuration);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.firewall.NiftySecurityGroup#createSecurityGroup(com.nifty.cloud.sdk.firewall.model.CreateSecurityGroupRequest)
	 */
	@Override
	public CreateSecurityGroupResult createSecurityGroup(CreateSecurityGroupRequest request) {
		return (CreateSecurityGroupResult) client.execute(request, CreateSecurityGroupResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.firewall.NiftySecurityGroup#deleteSecurityGroup(com.nifty.cloud.sdk.firewall.model.DeleteSecurityGroupRequest)
	 */
	@Override
	public DeleteSecurityGroupResult deleteSecurityGroup(DeleteSecurityGroupRequest request) {
		return (DeleteSecurityGroupResult) client.execute(request, DeleteSecurityGroupResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.firewall.NiftySecurityGroup#updateSecurityGroup(com.nifty.cloud.sdk.firewall.model.UpdateSecurityGroupRequest)
	 */
	@Override
	public UpdateSecurityGroupResult updateSecurityGroup(UpdateSecurityGroupRequest request) {
		return (UpdateSecurityGroupResult) client.execute(request, UpdateSecurityGroupResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.firewall.NiftySecurityGroup#describeSecurityGroups(com.nifty.cloud.sdk.firewall.model.DescribeSecurityGroupsRequest)
	 */
	@Override
	public DescribeSecurityGroupsResult describeSecurityGroups(DescribeSecurityGroupsRequest request) {
		return (DescribeSecurityGroupsResult) client.execute(request, DescribeSecurityGroupsResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.firewall.NiftySecurityGroup#authorizeSecurityGroupIngress(com.nifty.cloud.sdk.firewall.model.AuthorizeSecurityGroupIngressRequest)
	 */
	@Override
	public AuthorizeSecurityGroupIngressResult authorizeSecurityGroupIngress(AuthorizeSecurityGroupIngressRequest request) {
		return (AuthorizeSecurityGroupIngressResult) client.execute(request, AuthorizeSecurityGroupIngressResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.firewall.NiftySecurityGroup#revokeSecurityGroupIngress(com.nifty.cloud.sdk.firewall.model.RevokeSecurityGroupIngressRequest)
	 */
	@Override
	public RevokeSecurityGroupIngressResult revokeSecurityGroupIngress(RevokeSecurityGroupIngressRequest request) {
		return (RevokeSecurityGroupIngressResult) client.execute(request, RevokeSecurityGroupIngressResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.firewall.NiftySecurityGroup#registerInstancesWithSecurityGroup(com.nifty.cloud.sdk.firewall.model.RegisterInstancesWithSecurityGroupRequest)
	 */
	@Override
	public RegisterInstancesWithSecurityGroupResult registerInstancesWithSecurityGroup(RegisterInstancesWithSecurityGroupRequest request) {
		return (RegisterInstancesWithSecurityGroupResult) client.execute(request, RegisterInstancesWithSecurityGroupResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.firewall.NiftySecurityGroup#deregisterInstancesFromSecurityGroup(com.nifty.cloud.sdk.firewall.model.DeregisterInstancesFromSecurityGroupRequest)
	 */
	@Override
	public DeregisterInstancesFromSecurityGroupResult deregisterInstancesFromSecurityGroup(DeregisterInstancesFromSecurityGroupRequest request) {
		return (DeregisterInstancesFromSecurityGroupResult) client.execute(request, DeregisterInstancesFromSecurityGroupResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.firewall.NiftySecurityGroup#describeSecurityActivities(com.nifty.cloud.sdk.firewall.model.DescribeSecurityActivitiesRequest)
	 */
	@Override
	public DescribeSecurityActivitiesResult describeSecurityActivities(DescribeSecurityActivitiesRequest request) {
		return (DescribeSecurityActivitiesResult) client.execute(request, DescribeSecurityActivitiesResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.firewall.NiftySecurityGroup#niftyRegisterRoutersWithSecurityGroup(com.nifty.cloud.sdk.firewall.model.NiftyRegisterRoutersWithSecurityGroupRequest)
	 */
	@Override
	public NiftyRegisterRoutersWithSecurityGroupResult niftyRegisterRoutersWithSecurityGroup(NiftyRegisterRoutersWithSecurityGroupRequest request) {
		return (NiftyRegisterRoutersWithSecurityGroupResult) client.execute(request, NiftyRegisterRoutersWithSecurityGroupResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.firewall.NiftySecurityGroup#niftyDeregisterRoutersFromSecurityGroup(com.nifty.cloud.sdk.firewall.model.NiftyDeregisterRoutersFromSecurityGroupRequest)
	 */
	@Override
	public NiftyDeregisterRoutersFromSecurityGroupResult niftyDeregisterRoutersFromSecurityGroup(NiftyDeregisterRoutersFromSecurityGroupRequest request) {
		return (NiftyDeregisterRoutersFromSecurityGroupResult) client.execute(request, NiftyDeregisterRoutersFromSecurityGroupResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.firewall.NiftySecurityGroup#niftyRegisterVpnGatewaysWithSecurityGroup(com.nifty.cloud.sdk.firewall.model.NiftyRegisterVpnGatewaysWithSecurityGroupRequest)
	 */
	@Override
	public NiftyRegisterVpnGatewaysWithSecurityGroupResult niftyRegisterVpnGatewaysWithSecurityGroup(NiftyRegisterVpnGatewaysWithSecurityGroupRequest request) {
		return (NiftyRegisterVpnGatewaysWithSecurityGroupResult) client.execute(request, NiftyRegisterVpnGatewaysWithSecurityGroupResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.firewall.NiftySecurityGroup#niftyDeregisterVpnGatewaysFromSecurityGroup(com.nifty.cloud.sdk.firewall.model.NiftyDeregisterVpnGatewaysFromSecurityGroupRequest)
	 */
	@Override
	public NiftyDeregisterVpnGatewaysFromSecurityGroupResult niftyDeregisterVpnGatewaysFromSecurityGroup(NiftyDeregisterVpnGatewaysFromSecurityGroupRequest request) {
		return (NiftyDeregisterVpnGatewaysFromSecurityGroupResult) client.execute(request, NiftyDeregisterVpnGatewaysFromSecurityGroupResult.class);
	}
}
