/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.dhcp.model.transform;

import java.util.List;

import com.nifty.cloud.sdk.dhcp.model.DhcpStatusInformation;
import com.nifty.cloud.sdk.dhcp.model.NiftyDescribeDhcpStatusResult;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * NiftyDescribeDhcpStatusResponseType変換クラス。<br />
 * このクラスはレスポンスXMLのNiftyDescribeDhcpStatusResponse要素からNiftyDescribeDhcpStatusResultクラスを生成します。
 */
public class NiftyDescribeDhcpStatusResultConverter implements Converter {

	private static final String ELEMENT_REQUEST_ID = "requestId";
	private static final String ELEMENT_ROUTER_ID = "routerId";
	private static final String ELEMENT_ROUTER_NAME = "routerName";
	private static final String ELEMENT_DHCP_STATUS_INFORMATION_SET = "dhcpStatusInformationSet";

	/**
	 * 変換可能なクラスか判定します。
	 *
	 * @param clazz クラス
	 * @return 変換可能な場合true, 変換不可能な場合false
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
	 */
	@SuppressWarnings("rawtypes")
	@Override
	public boolean canConvert(Class clazz) {
		return clazz == NiftyDescribeDhcpStatusResult.class;
	}

	/**
	 * {@literal
	 * NiftyDescribeDhcpStatusResponseをNiftyDescribeDhcpStatusResultクラスに変換します。}
	 *
	 * @param reader XML読込リーダ
	 * @param context
	 * @return {@literal NiftyDescribeDhcpStatusResultオブジェクト}
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader, UnmarshallingContext)
	 */
	@SuppressWarnings("unchecked")
	@Override
	public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
		NiftyDescribeDhcpStatusResult niftyDescribeDhcpStatusResult = new NiftyDescribeDhcpStatusResult();
		Converter dhcpStatusInformationSetConverter = new DhcpStatusInformationSetConverter();

		String name = null;
		while (reader.hasMoreChildren()) {
			reader.moveDown();

			name = reader.getNodeName();
			if (name.equals(ELEMENT_REQUEST_ID)) {
				niftyDescribeDhcpStatusResult.setRequestId(reader.getValue());
			} else if (name.equals(ELEMENT_ROUTER_ID)) {
				niftyDescribeDhcpStatusResult.setRouterId(reader.getValue());
			} else if (name.equals(ELEMENT_ROUTER_NAME)) {
				niftyDescribeDhcpStatusResult.setRouterName(reader.getValue());
			} else if (name.equals(ELEMENT_DHCP_STATUS_INFORMATION_SET)) {
				niftyDescribeDhcpStatusResult.setDhcpStatusInformations((List<DhcpStatusInformation>) dhcpStatusInformationSetConverter.unmarshal(reader, context));
			}

			reader.moveUp();
		}

		return niftyDescribeDhcpStatusResult;
	}

	/**
	 * 未実装メソッド
	 */
	@Override
	public void marshal(Object paramObject,
			HierarchicalStreamWriter paramHierarchicalStreamWriter,
			MarshallingContext paramMarshallingContext) {
	}
}
