/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.dhcp.model.transform;

import java.util.ArrayList;
import java.util.List;

import com.nifty.cloud.sdk.dhcp.model.DhcpIpAddressInformation;
import com.nifty.cloud.sdk.dhcp.model.DhcpStatusInformation;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * DhcpStatusInformationSetType変換クラス。<br />
 * このクラスはレスポンスXMLのdhcpStatusInformationSet要素からDhcpStatusInformationクラスのリストを生成します。
 */
public class DhcpStatusInformationSetConverter implements Converter {

	private static final String ELEMENT_NETWORK_ID = "networkId";
	private static final String ELEMENT_PRIVATE_LAN_NAME = "privateLanName";
	private static final String ELEMENT_DHCP_IP_ADDRESS_INFORMATION = "dhcpIpAddressInformation";

	/**
	 * 変換可能なクラスか判定します。
	 *
	 * @param clazz クラス
	 * @return 変換可能な場合true, 変換不可能な場合false
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
	 */
	@SuppressWarnings("rawtypes")
	@Override
	public boolean canConvert(Class clazz) {
		Class[] interfaces = clazz.getInterfaces();
		for (Class i : interfaces) {
			if (i == List.class) {
				return true;
			}
		}
		return false;
	}

	/**
	 * {@literal
	 * dhcpStatusInformationSetをList<DhcpStatusInformation>クラスに変換します。}
	 *
	 * @param reader XML読込リーダ
	 * @param context
	 * @return {@literal List<DhcpStatusInformation>オブジェクト}
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader, UnmarshallingContext)
	 */
	@Override
	public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
		List<DhcpStatusInformation> dhcpStatusInformations = new ArrayList<DhcpStatusInformation>();
		Converter dhcpIpAddressInformationConverter = new DhcpIpAddressInformationConverter();

		String name = null;
		while (reader.hasMoreChildren()) {
			reader.moveDown();
			DhcpStatusInformation dhcpStatusInformation = new DhcpStatusInformation();

			while (reader.hasMoreChildren()) {
				reader.moveDown();

				name = reader.getNodeName();
				if (name.equals(ELEMENT_NETWORK_ID)) {
					dhcpStatusInformation.setNetworkId(reader.getValue());
				} else if (name.equals(ELEMENT_PRIVATE_LAN_NAME)) {
					dhcpStatusInformation.setPrivateLanName(reader.getValue());
				} else if (name.equals(ELEMENT_DHCP_IP_ADDRESS_INFORMATION)) {
					dhcpStatusInformation.setDhcpIpAddressInformation((DhcpIpAddressInformation) dhcpIpAddressInformationConverter.unmarshal(reader, context));
				}

				reader.moveUp();
			}

			dhcpStatusInformations.add(dhcpStatusInformation);
			reader.moveUp();
		}

		return dhcpStatusInformations;
	}

	/**
	 * 未実装メソッド
	 */
	@Override
	public void marshal(Object paramObject,
			HierarchicalStreamWriter paramHierarchicalStreamWriter,
			MarshallingContext paramMarshallingContext) {
	}
}
