/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.dhcp.model;

/**
 * StaticMapping設定情報クラス。<br />
 * このクラスはStaticMapping設定情報を格納します。
 *
 */
public class StaticMapping {

	/** IPアドレス */
	private String ipAddress;

	/** MACアドレス */
	private String macAddress;

	/** メモ */
	private String description;

	/**
	 * IPアドレスを取得します。
	 *
	 * @return IPアドレス
	 */
	public String getIpAddress() {
		return ipAddress;
	}

	/**
	 * IPアドレスを設定します。
	 *
	 * @param ipAddress IPアドレス
	 */
	public void setIpAddress(String ipAddress) {
		this.ipAddress = ipAddress;
	}

	/**
	 * IPアドレスを設定し、自オブジェクトを返します。
	 *
	 * @param ipAddress IPアドレス
	 * @return 自オブジェクト
	 */
	public StaticMapping withIpAddress(String ipAddress) {
		setIpAddress(ipAddress);
		return this;
	}

	/**
	 * MACアドレスを取得します。
	 *
	 * @return MACアドレス
	 */
	public String getMacAddress() {
		return macAddress;
	}

	/**
	 * MACアドレスを設定します。
	 *
	 * @param macAddress MACアドレス
	 */
	public void setMacAddress(String macAddress) {
		this.macAddress = macAddress;
	}

	/**
	 * MACアドレスを設定し、自オブジェクトを返します。
	 *
	 * @param macAddress MACアドレス
	 * @return 自オブジェクト
	 */
	public StaticMapping withMacAddress(String macAddress) {
		setMacAddress(macAddress);
		return this;
	}

	/**
	 * メモを取得します。
	 *
	 * @return メモ
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * メモを設定します。
	 *
	 * @param description メモ
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * メモを設定し、自オブジェクトを返します。
	 *
	 * @param description メモ
	 * @return 自オブジェクト
	 */
	public StaticMapping withDescription(String description) {
		setDescription(description);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[ipAddress=");
		builder.append(ipAddress);
		builder.append(", macAddress=");
		builder.append(macAddress);
		builder.append(", description=");
		builder.append(description);
		builder.append("]");
		return builder.toString();
	}
}
