/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.dhcp.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyReplaceDhcpOptionリクエストクラス。<br />
 * このクラスはNiftyReplaceDhcpOptionへのリクエストを構築します。
 *
 */
@Action("NiftyReplaceDhcpOption")
public class NiftyReplaceDhcpOptionRequest implements Request {

	/** ルーターユニークID */
	private String routerId;

	/** ルータ－名 */
	private String routerName;

	/** ネットワークユニークID */
	private String networkId;

	/** ネットワーク名 */
	private String networkName;

	/** 入れ替え後のDHCPオプションID */
	private String dhcpOptionsId;

	/** version up実施したのち、バックアップ状態を解除する事項への同意 */
	private Boolean agreement;

	/**
	 * デフォルトコンストラクタ。
	 */
	public NiftyReplaceDhcpOptionRequest() {
	}

	/**
	 * 入れ替え後のDHCPオプションIDを指定し、NiftyReplaceDhcpOptionRequestを構築します。
	 *
	 * @param dhcpOptionsId 入れ替え後のDHCPオプションID
	 */
	public NiftyReplaceDhcpOptionRequest(String dhcpOptionsId) {
		this.dhcpOptionsId = dhcpOptionsId;
	}

	/**
	 * ルーターユニークIDを取得します。
	 *
	 * @return ルーターユニークID
	 */
	@Query(name="RouterId")
	public String getRouterId() {
		return routerId;
	}

	/**
	 * ルーターユニークIDを設定します。
	 *
	 * @param routerId ルーターユニークID
	 */
	public void setRouterId(String routerId) {
		this.routerId = routerId;
	}

	/**
	 * ルーターユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param routerId ルーターユニークID
	 * @return 自オブジェクト
	 */
	public NiftyReplaceDhcpOptionRequest withRouterId(String routerId) {
		setRouterId(routerId);
		return this;
	}

	/**
	 * ルータ－名を取得します。
	 *
	 * @return ルータ－名
	 */
	@Query(name="RouterName")
	public String getRouterName() {
		return routerName;
	}

	/**
	 * ルータ－名を設定します。
	 *
	 * @param routerName ルータ－名
	 */
	public void setRouterName(String routerName) {
		this.routerName = routerName;
	}

	/**
	 * ルータ－名を設定し、自オブジェクトを返します。
	 *
	 * @param routerName ルータ－名
	 * @return 自オブジェクト
	 */
	public NiftyReplaceDhcpOptionRequest withRouterName(String routerName) {
		setRouterName(routerName);
		return this;
	}

	/**
	 * ネットワークユニークIDを取得します。
	 *
	 * @return ネットワークユニークID
	 */
	@Query(name="NetworkId")
	public String getNetworkId() {
		return networkId;
	}

	/**
	 * ネットワークユニークIDを設定します。
	 *
	 * @param networkId ネットワークユニークID
	 */
	public void setNetworkId(String networkId) {
		this.networkId = networkId;
	}

	/**
	 * ネットワークユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param networkId ネットワークユニークID
	 * @return 自オブジェクト
	 */
	public NiftyReplaceDhcpOptionRequest withNetworkId(String networkId) {
		setNetworkId(networkId);
		return this;
	}

	/**
	 * ネットワーク名を取得します。
	 *
	 * @return ネットワーク名
	 */
	@Query(name="NetworkName")
	public String getNetworkName() {
		return networkName;
	}

	/**
	 * ネットワーク名を設定します。
	 *
	 * @param networkName ネットワーク名
	 */
	public void setNetworkName(String networkName) {
		this.networkName = networkName;
	}

	/**
	 * ネットワーク名を設定し、自オブジェクトを返します。
	 *
	 * @param networkName ネットワーク名
	 * @return 自オブジェクト
	 */
	public NiftyReplaceDhcpOptionRequest withNetworkName(String networkName) {
		setNetworkName(networkName);
		return this;
	}

	/**
	 * 入れ替え後のDHCPオプションIDを取得します。
	 *
	 * @return 入れ替え後のDHCPオプションID
	 */
	@Query(name="DhcpOptionsId", require=true)
	public String getDhcpOptionsId() {
		return dhcpOptionsId;
	}

	/**
	 * 入れ替え後のDHCPオプションIDを設定します。
	 *
	 * @param dhcpOptionsId 入れ替え後のDHCPオプションID
	 */
	public void setDhcpOptionsId(String dhcpOptionsId) {
		this.dhcpOptionsId = dhcpOptionsId;
	}

	/**
	 * 入れ替え後のDHCPオプションIDを設定し、自オブジェクトを返します。
	 *
	 * @param dhcpOptionsId 入れ替え後のDHCPオプションID
	 * @return 自オブジェクト
	 */
	public NiftyReplaceDhcpOptionRequest withDhcpOptionsId(String dhcpOptionsId) {
		setDhcpOptionsId(dhcpOptionsId);
		return this;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を取得します。
	 *
	 * @return version up実施したのち、バックアップ状態を解除する事項への同意
	 */
	@Query(name="Agreement")
	public Boolean getAgreement() {
		return agreement;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を設定します。
	 *
	 * @param agreement version up実施したのち、バックアップ状態を解除する事項への同意
	 */
	public void setAgreement(Boolean agreement) {
		this.agreement = agreement;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を設定し、自オブジェクトを返します。
	 *
	 * @param agreement version up実施したのち、バックアップ状態を解除する事項への同意
	 * @return 自オブジェクト
	 */
	public NiftyReplaceDhcpOptionRequest withAgreement(Boolean agreement) {
		setAgreement(agreement);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[routerId=");
		builder.append(routerId);
		builder.append(", routerName=");
		builder.append(routerName);
		builder.append(", networkId=");
		builder.append(networkId);
		builder.append(", networkName=");
		builder.append(networkName);
		builder.append(", dhcpOptionsId=");
		builder.append(dhcpOptionsId);
		builder.append(", agreement=");
		builder.append(agreement);
		builder.append("]");
		return builder.toString();
	}
}
