/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.dhcp.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyReplaceDhcpConfigリクエストクラス。<br />
 * このクラスはNiftyReplaceDhcpConfigへのリクエストを構築します。
 *
 */
@Action("NiftyReplaceDhcpConfig")
public class NiftyReplaceDhcpConfigRequest implements Request {

	/** ルーターユニークID */
	private String routerId;

	/** ルータ－名 */
	private String routerName;

	/** ネットワークユニークID */
	private String networkId;

	/** ネットワーク名 */
	private String networkName;

	/** 入れ替え後のDHCPコンフィグID */
	private String dhcpConfigId;

	/** version up実施したのち、バックアップ状態を解除する事項への同意 */
	private Boolean agreement;

	/**
	 * デフォルトコンストラクタ。
	 */
	public NiftyReplaceDhcpConfigRequest() {
	}

	/**
	 * 入れ替え後のDHCPコンフィグIDを指定し、NiftyReplaceDhcpConfigRequestを構築します。
	 *
	 * @param dhcpConfigId 入れ替え後のDHCPコンフィグID
	 */
	public NiftyReplaceDhcpConfigRequest(String dhcpConfigId) {
		this.dhcpConfigId = dhcpConfigId;
	}

	/**
	 * ルーターユニークIDを取得します。
	 *
	 * @return ルーターユニークID
	 */
	@Query(name="RouterId")
	public String getRouterId() {
		return routerId;
	}

	/**
	 * ルーターユニークIDを設定します。
	 *
	 * @param routerId ルーターユニークID
	 */
	public void setRouterId(String routerId) {
		this.routerId = routerId;
	}

	/**
	 * ルーターユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param routerId ルーターユニークID
	 * @return 自オブジェクト
	 */
	public NiftyReplaceDhcpConfigRequest withRouterId(String routerId) {
		setRouterId(routerId);
		return this;
	}

	/**
	 * ルータ－名を取得します。
	 *
	 * @return ルータ－名
	 */
	@Query(name="RouterName")
	public String getRouterName() {
		return routerName;
	}

	/**
	 * ルータ－名を設定します。
	 *
	 * @param routerName ルータ－名
	 */
	public void setRouterName(String routerName) {
		this.routerName = routerName;
	}

	/**
	 * ルータ－名を設定し、自オブジェクトを返します。
	 *
	 * @param routerName ルータ－名
	 * @return 自オブジェクト
	 */
	public NiftyReplaceDhcpConfigRequest withRouterName(String routerName) {
		setRouterName(routerName);
		return this;
	}

	/**
	 * ネットワークユニークIDを取得します。
	 *
	 * @return ネットワークユニークID
	 */
	@Query(name="NetworkId")
	public String getNetworkId() {
		return networkId;
	}

	/**
	 * ネットワークユニークIDを設定します。
	 *
	 * @param networkId ネットワークユニークID
	 */
	public void setNetworkId(String networkId) {
		this.networkId = networkId;
	}

	/**
	 * ネットワークユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param networkId ネットワークユニークID
	 * @return 自オブジェクト
	 */
	public NiftyReplaceDhcpConfigRequest withNetworkId(String networkId) {
		setNetworkId(networkId);
		return this;
	}

	/**
	 * ネットワーク名を取得します。
	 *
	 * @return ネットワーク名
	 */
	@Query(name="NetworkName")
	public String getNetworkName() {
		return networkName;
	}

	/**
	 * ネットワーク名を設定します。
	 *
	 * @param networkName ネットワーク名
	 */
	public void setNetworkName(String networkName) {
		this.networkName = networkName;
	}

	/**
	 * ネットワーク名を設定し、自オブジェクトを返します。
	 *
	 * @param networkName ネットワーク名
	 * @return 自オブジェクト
	 */
	public NiftyReplaceDhcpConfigRequest withNetworkName(String networkName) {
		setNetworkName(networkName);
		return this;
	}

	/**
	 * 入れ替え後のDHCPコンフィグIDを取得します。
	 *
	 * @return 入れ替え後のDHCPコンフィグID
	 */
	@Query(name="DhcpConfigId", require=true)
	public String getDhcpConfigId() {
		return dhcpConfigId;
	}

	/**
	 * 入れ替え後のDHCPコンフィグIDを設定します。
	 *
	 * @param dhcpConfigId 入れ替え後のDHCPコンフィグID
	 */
	public void setDhcpConfigId(String dhcpConfigId) {
		this.dhcpConfigId = dhcpConfigId;
	}

	/**
	 * 入れ替え後のDHCPコンフィグIDを設定し、自オブジェクトを返します。
	 *
	 * @param dhcpConfigId 入れ替え後のDHCPコンフィグID
	 * @return 自オブジェクト
	 */
	public NiftyReplaceDhcpConfigRequest withDhcpConfigId(String dhcpConfigId) {
		setDhcpConfigId(dhcpConfigId);
		return this;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を取得します。
	 *
	 * @return version up実施したのち、バックアップ状態を解除する事項への同意
	 */
	@Query(name="Agreement")
	public Boolean getAgreement() {
		return agreement;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を設定します。
	 *
	 * @param agreement version up実施したのち、バックアップ状態を解除する事項への同意
	 */
	public void setAgreement(Boolean agreement) {
		this.agreement = agreement;
	}

	/**
	 * version up実施したのち、バックアップ状態を解除する事項への同意を設定し、自オブジェクトを返します。
	 *
	 * @param agreement version up実施したのち、バックアップ状態を解除する事項への同意
	 * @return 自オブジェクト
	 */
	public NiftyReplaceDhcpConfigRequest withAgreement(Boolean agreement) {
		setAgreement(agreement);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[routerId=");
		builder.append(routerId);
		builder.append(", routerName=");
		builder.append(routerName);
		builder.append(", networkId=");
		builder.append(networkId);
		builder.append(", networkName=");
		builder.append(networkName);
		builder.append(", dhcpConfigId=");
		builder.append(dhcpConfigId);
		builder.append(", agreement=");
		builder.append(agreement);
		builder.append("]");
		return builder.toString();
	}
}
