/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.dhcp.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.dhcp.model.transform.NiftyDescribeDhcpStatusResultConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * NiftyDescribeDhcpStatus処理結果クラス。<br />
 * このクラスはNiftyDescribeDhcpStatusのレスポンスを格納します。
 */
@XStreamAlias("NiftyDescribeDhcpStatusResponse")
@XStreamConverter(NiftyDescribeDhcpStatusResultConverter.class)
public class NiftyDescribeDhcpStatusResult extends Result {

	/** リクエスト識別子 */
	private String requestId;

	/** ルーターユニークID */
	private String routerId;

	/** ルータ－名 */
	private String routerName;

	/** DHCPのステータス情報リスト */
	private List<DhcpStatusInformation> dhcpStatusInformations;

	/**
	 * リクエスト識別子を取得します。
	 *
	 * @return リクエスト識別子
	 */
	public String getRequestId() {
		return requestId;
	}

	/**
	 * リクエスト識別子を設定します。
	 *
	 * @param requestId リクエスト識別子
	 */
	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	/**
	 * リクエスト識別子を設定し、自オブジェクトを返します。
	 *
	 * @param requestId リクエスト識別子
	 * @return 自オブジェクト
	 */
	public NiftyDescribeDhcpStatusResult withRequestId(String requestId) {
		setRequestId(requestId);
		return this;
	}

	/**
	 * ルーターユニークIDを取得します。
	 *
	 * @return ルーターユニークID
	 */
	public String getRouterId() {
		return routerId;
	}

	/**
	 * ルーターユニークIDを設定します。
	 *
	 * @param routerId ルーターユニークID
	 */
	public void setRouterId(String routerId) {
		this.routerId = routerId;
	}

	/**
	 * ルーターユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param routerId ルーターユニークID
	 * @return 自オブジェクト
	 */
	public NiftyDescribeDhcpStatusResult withRouterId(String routerId) {
		setRouterId(routerId);
		return this;
	}

	/**
	 * ルータ－名を取得します。
	 *
	 * @return ルータ－名
	 */
	public String getRouterName() {
		return routerName;
	}

	/**
	 * ルータ－名を設定します。
	 *
	 * @param routerName ルータ－名
	 */
	public void setRouterName(String routerName) {
		this.routerName = routerName;
	}

	/**
	 * ルータ－名を設定し、自オブジェクトを返します。
	 *
	 * @param routerName ルータ－名
	 * @return 自オブジェクト
	 */
	public NiftyDescribeDhcpStatusResult withRouterName(String routerName) {
		setRouterName(routerName);
		return this;
	}

	/**
	 * DHCPのステータス情報リストを取得します。
	 *
	 * @return DHCPのステータス情報リスト
	 */
	public List<DhcpStatusInformation> getDhcpStatusInformations() {
		return dhcpStatusInformations;
	}

	/**
	 * DHCPのステータス情報リストを設定します。
	 *
	 * @param dhcpStatusInformations DHCPのステータス情報リスト
	 */
	public void setDhcpStatusInformations(List<DhcpStatusInformation> dhcpStatusInformations) {
		this.dhcpStatusInformations = dhcpStatusInformations;
	}

	/**
	 * DHCPのステータス情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param dhcpStatusInformations DHCPのステータス情報の配列
	 * @return 自オブジェクト
	 */
	public NiftyDescribeDhcpStatusResult withDhcpStatusInformations(DhcpStatusInformation ... dhcpStatusInformations) {
		if (this.dhcpStatusInformations == null) this.dhcpStatusInformations = new ArrayList<DhcpStatusInformation>();
		for (DhcpStatusInformation dhcpStatusInformation : dhcpStatusInformations) {
			getDhcpStatusInformations().add(dhcpStatusInformation);
		}
		return this;
	}

	/**
	 * DHCPのステータス情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param dhcpStatusInformations DHCPのステータス情報リスト
	 * @return 自オブジェクト
	 */
	public NiftyDescribeDhcpStatusResult withDhcpStatusInformations(Collection<DhcpStatusInformation> dhcpStatusInformations) {
		if (this.dhcpStatusInformations == null) this.dhcpStatusInformations = new ArrayList<DhcpStatusInformation>();
		if (dhcpStatusInformations != null) {
			getDhcpStatusInformations().addAll(dhcpStatusInformations);
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[requestId=");
		builder.append(requestId);
		builder.append(", routerId=");
		builder.append(routerId);
		builder.append(", routerName=");
		builder.append(routerName);
		builder.append(", dhcpStatusInformations=");
		builder.append(dhcpStatusInformations);
		builder.append("]");
		return builder.toString();
	}
}
