/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.dhcp.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyDescribeDhcpConfigsリクエストクラス。<br />
 * このクラスはNiftyDescribeDhcpConfigsへのリクエストを構築します。
 *
 */
@Action("NiftyDescribeDhcpConfigs")
public class NiftyDescribeDhcpConfigsRequest implements Request {

	/** DHCPコンフィグ情報リスト */
	private List<DhcpConfigIdSet> dhcpConfigs;

	/** 絞り込み情報リスト */
	private List<Filter> filters;

	/**
	 * DHCPコンフィグ情報リストを取得します。
	 *
	 * @return DHCPコンフィグ情報リスト
	 */
	@Query(name="")
	public List<DhcpConfigIdSet> getDhcpConfigs() {
		return dhcpConfigs;
	}

	/**
	 * DHCPコンフィグ情報リストを設定します。
	 *
	 * @param dhcpConfigs DHCPコンフィグ情報リスト
	 */
	public void setDhcpConfigs(List<DhcpConfigIdSet> dhcpConfigs) {
		this.dhcpConfigs = dhcpConfigs;
	}

	/**
	 * DHCPコンフィグ情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param dhcpConfigs DHCPコンフィグ情報の配列
	 * @return 自オブジェクト
	 */
	public NiftyDescribeDhcpConfigsRequest withDhcpConfigs(DhcpConfigIdSet ... dhcpConfigs) {
		if (this.dhcpConfigs == null) this.dhcpConfigs = new ArrayList<DhcpConfigIdSet>();
		for (DhcpConfigIdSet dhcpConfig : dhcpConfigs) {
			getDhcpConfigs().add(dhcpConfig);
		}
		return this;
	}

	/**
	 * DHCPコンフィグ情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param dhcpConfigs DHCPコンフィグ情報リスト
	 * @return 自オブジェクト
	 */
	public NiftyDescribeDhcpConfigsRequest withDhcpConfigs(Collection<DhcpConfigIdSet> dhcpConfigs) {
		if (this.dhcpConfigs == null) this.dhcpConfigs = new ArrayList<DhcpConfigIdSet>();
		if (dhcpConfigs != null) {
			getDhcpConfigs().addAll(dhcpConfigs);
		}
		return this;
	}

	/**
	 * 絞り込み情報リストを取得します。
	 *
	 * @return 絞り込み情報リスト
	 */
	@Query(name="Filter")
	public List<Filter> getFilters() {
		return filters;
	}

	/**
	 * 絞り込み情報リストを設定します。
	 *
	 * @param filters 絞り込み情報リスト
	 */
	public void setFilters(List<Filter> filters) {
		this.filters = filters;
	}

	/**
	 * 絞り込み情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param filters 絞り込み情報の配列
	 * @return 自オブジェクト
	 */
	public NiftyDescribeDhcpConfigsRequest withFilters(Filter ... filters) {
		if (this.filters == null) this.filters = new ArrayList<Filter>();
		for (Filter filter : filters) {
			getFilters().add(filter);
		}
		return this;
	}

	/**
	 * 絞り込み情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param filters 絞り込み情報リスト
	 * @return 自オブジェクト
	 */
	public NiftyDescribeDhcpConfigsRequest withFilters(Collection<Filter> filters) {
		if (this.filters == null) this.filters = new ArrayList<Filter>();
		if (filters != null) {
			getFilters().addAll(filters);
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[dhcpConfigs=");
		builder.append(dhcpConfigs);
		builder.append(", filters=");
		builder.append(filters);
		builder.append("]");
		return builder.toString();
	}
}
