/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.dhcp.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyDeleteDhcpStaticMappingリクエストクラス。<br />
 * このクラスはNiftyDeleteDhcpStaticMappingへのリクエストを構築します。
 *
 */
@Action("NiftyDeleteDhcpStaticMapping")
public class NiftyDeleteDhcpStaticMappingRequest implements Request {

	/** DHCPコンフィグID */
	private String dhcpConfigId;

	/** IPアドレス */
	private String ipAddress;

	/** MACアドレス */
	private String macAddress;

	/**
	 * デフォルトコンストラクタ。
	 */
	public NiftyDeleteDhcpStaticMappingRequest() {
	}

	/**
	 * DHCPコンフィグID,IPアドレス,MACアドレスを指定し、NiftyDeleteDhcpStaticMappingRequestを構築します。
	 *
	 * @param dhcpConfigId DHCPコンフィグID
	 * @param ipAddress IPアドレス
	 * @param macAddress MACアドレス
	 */
	public NiftyDeleteDhcpStaticMappingRequest(String dhcpConfigId, String ipAddress, String macAddress) {
		this.dhcpConfigId = dhcpConfigId;
		this.ipAddress = ipAddress;
		this.macAddress = macAddress;
	}

	/**
	 * DHCPコンフィグIDを取得します。
	 *
	 * @return DHCPコンフィグID
	 */
	@Query(name="DhcpConfigId", require=true)
	public String getDhcpConfigId() {
		return dhcpConfigId;
	}

	/**
	 * DHCPコンフィグIDを設定します。
	 *
	 * @param dhcpConfigId DHCPコンフィグID
	 */
	public void setDhcpConfigId(String dhcpConfigId) {
		this.dhcpConfigId = dhcpConfigId;
	}

	/**
	 * DHCPコンフィグIDを設定し、自オブジェクトを返します。
	 *
	 * @param dhcpConfigId DHCPコンフィグID
	 * @return 自オブジェクト
	 */
	public NiftyDeleteDhcpStaticMappingRequest withDhcpConfigId(String dhcpConfigId) {
		setDhcpConfigId(dhcpConfigId);
		return this;
	}

	/**
	 * IPアドレスを取得します。
	 *
	 * @return IPアドレス
	 */
	@Query(name="IpAddress", require=true)
	public String getIpAddress() {
		return ipAddress;
	}

	/**
	 * IPアドレスを設定します。
	 *
	 * @param ipAddress IPアドレス
	 */
	public void setIpAddress(String ipAddress) {
		this.ipAddress = ipAddress;
	}

	/**
	 * IPアドレスを設定し、自オブジェクトを返します。
	 *
	 * @param ipAddress IPアドレス
	 * @return 自オブジェクト
	 */
	public NiftyDeleteDhcpStaticMappingRequest withIpAddress(String ipAddress) {
		setIpAddress(ipAddress);
		return this;
	}

	/**
	 * MACアドレスを取得します。
	 *
	 * @return MACアドレス
	 */
	@Query(name="MacAddress", require=true)
	public String getMacAddress() {
		return macAddress;
	}

	/**
	 * MACアドレスを設定します。
	 *
	 * @param macAddress MACアドレス
	 */
	public void setMacAddress(String macAddress) {
		this.macAddress = macAddress;
	}

	/**
	 * MACアドレスを設定し、自オブジェクトを返します。
	 *
	 * @param macAddress MACアドレス
	 * @return 自オブジェクト
	 */
	public NiftyDeleteDhcpStaticMappingRequest withMacAddress(String macAddress) {
		setMacAddress(macAddress);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[dhcpConfigId=");
		builder.append(dhcpConfigId);
		builder.append(", ipAddress=");
		builder.append(ipAddress);
		builder.append(", macAddress=");
		builder.append(macAddress);
		builder.append("]");
		return builder.toString();
	}
}
