/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.dhcp.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyDeleteDhcpIpAddressPoolリクエストクラス。<br />
 * このクラスはNiftyDeleteDhcpIpAddressPoolへのリクエストを構築します。
 *
 */
@Action("NiftyDeleteDhcpIpAddressPool")
public class NiftyDeleteDhcpIpAddressPoolRequest implements Request {

	/** DHCPコンフィグID */
	private String dhcpConfigId;

	/** 開始IPアドレス */
	private String startIpAddress;

	/** 終了IPアドレス */
	private String stopIpAddress;

	/**
	 * デフォルトコンストラクタ。
	 */
	public NiftyDeleteDhcpIpAddressPoolRequest() {
	}

	/**
	 * DHCPコンフィグID,開始IPアドレス,終了IPアドレスを指定し、NiftyDeleteDhcpIpAddressPoolRequestを構築します。
	 *
	 * @param dhcpConfigId DHCPコンフィグID
	 * @param startIpAddress 開始IPアドレス
	 * @param stopIpAddress 終了IPアドレス
	 */
	public NiftyDeleteDhcpIpAddressPoolRequest(String dhcpConfigId, String startIpAddress, String stopIpAddress) {
		this.dhcpConfigId = dhcpConfigId;
		this.startIpAddress = startIpAddress;
		this.stopIpAddress = stopIpAddress;
	}

	/**
	 * DHCPコンフィグIDを取得します。
	 *
	 * @return DHCPコンフィグID
	 */
	@Query(name="DhcpConfigId", require=true)
	public String getDhcpConfigId() {
		return dhcpConfigId;
	}

	/**
	 * DHCPコンフィグIDを設定します。
	 *
	 * @param dhcpConfigId DHCPコンフィグID
	 */
	public void setDhcpConfigId(String dhcpConfigId) {
		this.dhcpConfigId = dhcpConfigId;
	}

	/**
	 * DHCPコンフィグIDを設定し、自オブジェクトを返します。
	 *
	 * @param dhcpConfigId DHCPコンフィグID
	 * @return 自オブジェクト
	 */
	public NiftyDeleteDhcpIpAddressPoolRequest withDhcpConfigId(String dhcpConfigId) {
		setDhcpConfigId(dhcpConfigId);
		return this;
	}

	/**
	 * 開始IPアドレスを取得します。
	 *
	 * @return 開始IPアドレス
	 */
	@Query(name="StartIpAddress", require=true)
	public String getStartIpAddress() {
		return startIpAddress;
	}

	/**
	 * 開始IPアドレスを設定します。
	 *
	 * @param startIpAddress 開始IPアドレス
	 */
	public void setStartIpAddress(String startIpAddress) {
		this.startIpAddress = startIpAddress;
	}

	/**
	 * 開始IPアドレスを設定し、自オブジェクトを返します。
	 *
	 * @param startIpAddress 開始IPアドレス
	 * @return 自オブジェクト
	 */
	public NiftyDeleteDhcpIpAddressPoolRequest withStartIpAddress(String startIpAddress) {
		setStartIpAddress(startIpAddress);
		return this;
	}

	/**
	 * 終了IPアドレスを取得します。
	 *
	 * @return 終了IPアドレス
	 */
	@Query(name="StopIpAddress", require=true)
	public String getStopIpAddress() {
		return stopIpAddress;
	}

	/**
	 * 終了IPアドレスを設定します。
	 *
	 * @param stopIpAddress 終了IPアドレス
	 */
	public void setStopIpAddress(String stopIpAddress) {
		this.stopIpAddress = stopIpAddress;
	}

	/**
	 * 終了IPアドレスを設定し、自オブジェクトを返します。
	 *
	 * @param stopIpAddress 終了IPアドレス
	 * @return 自オブジェクト
	 */
	public NiftyDeleteDhcpIpAddressPoolRequest withStopIpAddress(String stopIpAddress) {
		setStopIpAddress(stopIpAddress);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[dhcpConfigId=");
		builder.append(dhcpConfigId);
		builder.append(", startIpAddress=");
		builder.append(startIpAddress);
		builder.append(", stopIpAddress=");
		builder.append(stopIpAddress);
		builder.append("]");
		return builder.toString();
	}
}
