/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.dhcp.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyDeleteDhcpConfigリクエストクラス。<br />
 * このクラスはNiftyDeleteDhcpConfigへのリクエストを構築します。
 *
 */
@Action("NiftyDeleteDhcpConfig")
public class NiftyDeleteDhcpConfigRequest implements Request {

	/** DHCPコンフィグID */
	private String dhcpConfigId;

	/**
	 * デフォルトコンストラクタ。
	 */
	public NiftyDeleteDhcpConfigRequest() {
	}

	/**
	 * DHCPコンフィグIDを指定し、NiftyDeleteDhcpConfigRequestを構築します。
	 *
	 * @param dhcpConfigId DHCPコンフィグID
	 */
	public NiftyDeleteDhcpConfigRequest(String dhcpConfigId) {
		this.dhcpConfigId = dhcpConfigId;
	}

	/**
	 * DHCPコンフィグIDを取得します。
	 *
	 * @return DHCPコンフィグID
	 */
	@Query(name="DhcpConfigId", require=true)
	public String getDhcpConfigId() {
		return dhcpConfigId;
	}

	/**
	 * DHCPコンフィグIDを設定します。
	 *
	 * @param dhcpConfigId DHCPコンフィグID
	 */
	public void setDhcpConfigId(String dhcpConfigId) {
		this.dhcpConfigId = dhcpConfigId;
	}

	/**
	 * DHCPコンフィグIDを設定し、自オブジェクトを返します。
	 *
	 * @param dhcpConfigId DHCPコンフィグID
	 * @return 自オブジェクト
	 */
	public NiftyDeleteDhcpConfigRequest withDhcpConfigId(String dhcpConfigId) {
		setDhcpConfigId(dhcpConfigId);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[dhcpConfigId=");
		builder.append(dhcpConfigId);
		builder.append("]");
		return builder.toString();
	}
}
