/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.dhcp.model;

/**
 * IpAddressPool設定情報クラス。<br />
 * このクラスはIpAddressPool設定情報を格納します。
 *
 */
public class IpAddressPool {

	/** 開始IPアドレス */
	private String startIpAddress;

	/** 終了IPアドレス */
	private String stopIpAddress;

	/** メモ */
	private String description;

	/**
	 * 開始IPアドレスを取得します。
	 *
	 * @return 開始IPアドレス
	 */
	public String getStartIpAddress() {
		return startIpAddress;
	}

	/**
	 * 開始IPアドレスを設定します。
	 *
	 * @param startIpAddress 開始IPアドレス
	 */
	public void setStartIpAddress(String startIpAddress) {
		this.startIpAddress = startIpAddress;
	}

	/**
	 * 開始IPアドレスを設定し、自オブジェクトを返します。
	 *
	 * @param startIpAddress 開始IPアドレス
	 * @return 自オブジェクト
	 */
	public IpAddressPool withStartIpAddress(String startIpAddress) {
		setStartIpAddress(startIpAddress);
		return this;
	}

	/**
	 * 終了IPアドレスを取得します。
	 *
	 * @return 終了IPアドレス
	 */
	public String getStopIpAddress() {
		return stopIpAddress;
	}

	/**
	 * 終了IPアドレスを設定します。
	 *
	 * @param stopIpAddress 終了IPアドレス
	 */
	public void setStopIpAddress(String stopIpAddress) {
		this.stopIpAddress = stopIpAddress;
	}

	/**
	 * 終了IPアドレスを設定し、自オブジェクトを返します。
	 *
	 * @param stopIpAddress 終了IPアドレス
	 * @return 自オブジェクト
	 */
	public IpAddressPool withStopIpAddress(String stopIpAddress) {
		setStopIpAddress(stopIpAddress);
		return this;
	}

	/**
	 * メモを取得します。
	 *
	 * @return メモ
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * メモを設定します。
	 *
	 * @param description メモ
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * メモを設定し、自オブジェクトを返します。
	 *
	 * @param description メモ
	 * @return 自オブジェクト
	 */
	public IpAddressPool withDescription(String description) {
		setDescription(description);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[startIpAddress=");
		builder.append(startIpAddress);
		builder.append(", stopIpAddress=");
		builder.append(stopIpAddress);
		builder.append(", description=");
		builder.append(description);
		builder.append("]");
		return builder.toString();
	}
}
