/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.dhcp.model;

/**
 * DHCPステータス情報クラス。<br />
 * このクラスはDHCPステータス情報を格納します。
 *
 */
public class DhcpStatusInformation {

	/** ネットワークユニークID */
	private String networkId;

	/** ネットワーク名 */
	private String privateLanName;

	/** DHCPIPアドレス情報 */
	private DhcpIpAddressInformation dhcpIpAddressInformation;

	/**
	 * ネットワークユニークIDを取得します。
	 *
	 * @return ネットワークユニークID
	 */
	public String getNetworkId() {
		return networkId;
	}

	/**
	 * ネットワークユニークIDを設定します。
	 *
	 * @param networkId ネットワークユニークID
	 */
	public void setNetworkId(String networkId) {
		this.networkId = networkId;
	}

	/**
	 * ネットワークユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param networkId ネットワークユニークID
	 * @return 自オブジェクト
	 */
	public DhcpStatusInformation withNetworkId(String networkId) {
		setNetworkId(networkId);
		return this;
	}

	/**
	 * ネットワーク名を取得します。
	 *
	 * @return ネットワーク名
	 */
	public String getPrivateLanName() {
		return privateLanName;
	}

	/**
	 * ネットワーク名を設定します。
	 *
	 * @param privateLanName ネットワーク名
	 */
	public void setPrivateLanName(String privateLanName) {
		this.privateLanName = privateLanName;
	}

	/**
	 * ネットワーク名を設定し、自オブジェクトを返します。
	 *
	 * @param privateLanName ネットワーク名
	 * @return 自オブジェクト
	 */
	public DhcpStatusInformation withPrivateLanName(String privateLanName) {
		setPrivateLanName(privateLanName);
		return this;
	}

	/**
	 * DHCPIPアドレス情報を取得します。
	 *
	 * @return DHCPIPアドレス情報
	 */
	public DhcpIpAddressInformation getDhcpIpAddressInformation() {
		return dhcpIpAddressInformation;
	}

	/**
	 * DHCPIPアドレス情報を設定します。
	 *
	 * @param dhcpIpAddressInformation DHCPIPアドレス情報
	 */
	public void setDhcpIpAddressInformation(DhcpIpAddressInformation dhcpIpAddressInformation) {
		this.dhcpIpAddressInformation = dhcpIpAddressInformation;
	}

	/**
	 * DHCPIPアドレス情報を設定し、自オブジェクトを返します。
	 *
	 * @param dhcpIpAddressInformation DHCPIPアドレス情報
	 * @return 自オブジェクト
	 */
	public DhcpStatusInformation withDhcpIpAddressInformation(DhcpIpAddressInformation dhcpIpAddressInformation) {
		setDhcpIpAddressInformation(dhcpIpAddressInformation);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[networkId=");
		builder.append(networkId);
		builder.append(", privateLanName=");
		builder.append(privateLanName);
		builder.append(", dhcpIpAddressInformation=");
		builder.append(dhcpIpAddressInformation);
		builder.append("]");
		return builder.toString();
	}
}
