/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.dhcp.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * DHCPIPアドレス情報クラス。<br />
 * このクラスはDHCPIPアドレス情報を格納します。
 *
 */
public class DhcpIpAddressInformation {

	/** プールレンジ情報リスト */
	private List<IpAddressPool> ipAddressPools;

	/** IPアドレス情報リスト */
	private List<DhcpIpAddress> dhcpIpAddresses;

	/**
	 * プールレンジ情報リストを取得します。
	 *
	 * @return プールレンジ情報リスト
	 */
	public List<IpAddressPool> getIpAddressPools() {
		return ipAddressPools;
	}

	/**
	 * プールレンジ情報リストを設定します。
	 *
	 * @param ipAddressPools プールレンジ情報リスト
	 */
	public void setIpAddressPools(List<IpAddressPool> ipAddressPools) {
		this.ipAddressPools = ipAddressPools;
	}

	/**
	 * プールレンジ情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param ipAddressPools プールレンジ情報の配列
	 * @return 自オブジェクト
	 */
	public DhcpIpAddressInformation withIpAddressPools(IpAddressPool ... ipAddressPools) {
		if (this.ipAddressPools == null) this.ipAddressPools = new ArrayList<IpAddressPool>();
		for (IpAddressPool ipAddressPool : ipAddressPools) {
			getIpAddressPools().add(ipAddressPool);
		}
		return this;
	}

	/**
	 * プールレンジ情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param ipAddressPools プールレンジ情報リスト
	 * @return 自オブジェクト
	 */
	public DhcpIpAddressInformation withIpAddressPools(Collection<IpAddressPool> ipAddressPools) {
		if (this.ipAddressPools == null) this.ipAddressPools = new ArrayList<IpAddressPool>();
		if (ipAddressPools != null) {
			getIpAddressPools().addAll(ipAddressPools);
		}
		return this;
	}

	/**
	 * IPアドレス情報リストを取得します。
	 *
	 * @return IPアドレス情報リスト
	 */
	public List<DhcpIpAddress> getDhcpIpAddresses() {
		return dhcpIpAddresses;
	}

	/**
	 * IPアドレス情報リストを設定します。
	 *
	 * @param dhcpIpAddresses IPアドレス情報リスト
	 */
	public void setDhcpIpAddresses(List<DhcpIpAddress> dhcpIpAddresses) {
		this.dhcpIpAddresses = dhcpIpAddresses;
	}

	/**
	 * IPアドレス情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param dhcpIpAddresses IPアドレス情報の配列
	 * @return 自オブジェクト
	 */
	public DhcpIpAddressInformation withDhcpIpAddresses(DhcpIpAddress ... dhcpIpAddresses) {
		if (this.dhcpIpAddresses == null) this.dhcpIpAddresses = new ArrayList<DhcpIpAddress>();
		for (DhcpIpAddress dhcpIpAddress : dhcpIpAddresses) {
			getDhcpIpAddresses().add(dhcpIpAddress);
		}
		return this;
	}

	/**
	 * IPアドレス情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param dhcpIpAddresses IPアドレス情報リスト
	 * @return 自オブジェクト
	 */
	public DhcpIpAddressInformation withDhcpIpAddresses(Collection<DhcpIpAddress> dhcpIpAddresses) {
		if (this.dhcpIpAddresses == null) this.dhcpIpAddresses = new ArrayList<DhcpIpAddress>();
		if (dhcpIpAddresses != null) {
			getDhcpIpAddresses().addAll(dhcpIpAddresses);
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[ipAddressPools=");
		builder.append(ipAddressPools);
		builder.append(", dhcpIpAddresses=");
		builder.append(dhcpIpAddresses);
		builder.append("]");
		return builder.toString();
	}
}
