/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.dhcp.model;

import java.util.Date;

/**
 * IPアドレス情報クラス。<br />
 * このクラスはIPアドレス情報を格納します。
 *
 */
public class DhcpIpAddress {

	/** IPアドレス */
	private String ipAddress;

	/** MACアドレス */
	private String macAddress;

	/** dhcpの払い出し状態 */
	private String leaseType;

	/** IPアドレスリリース日 */
	private Date leaseExpiration;

	/** IPアドレスが設定されているリソース名 */
	private String clientName;

	/** StaticMappingのメモ(500字,CDATAつき) */
	private String description;

	/**
	 * IPアドレスを取得します。
	 *
	 * @return IPアドレス
	 */
	public String getIpAddress() {
		return ipAddress;
	}

	/**
	 * IPアドレスを設定します。
	 *
	 * @param ipAddress IPアドレス
	 */
	public void setIpAddress(String ipAddress) {
		this.ipAddress = ipAddress;
	}

	/**
	 * IPアドレスを設定し、自オブジェクトを返します。
	 *
	 * @param ipAddress IPアドレス
	 * @return 自オブジェクト
	 */
	public DhcpIpAddress withIpAddress(String ipAddress) {
		setIpAddress(ipAddress);
		return this;
	}

	/**
	 * MACアドレスを取得します。
	 *
	 * @return MACアドレス
	 */
	public String getMacAddress() {
		return macAddress;
	}

	/**
	 * MACアドレスを設定します。
	 *
	 * @param macAddress MACアドレス
	 */
	public void setMacAddress(String macAddress) {
		this.macAddress = macAddress;
	}

	/**
	 * MACアドレスを設定し、自オブジェクトを返します。
	 *
	 * @param macAddress MACアドレス
	 * @return 自オブジェクト
	 */
	public DhcpIpAddress withMacAddress(String macAddress) {
		setMacAddress(macAddress);
		return this;
	}

	/**
	 * dhcpの払い出し状態を取得します。
	 *
	 * @return dhcpの払い出し状態
	 */
	public String getLeaseType() {
		return leaseType;
	}

	/**
	 * dhcpの払い出し状態を設定します。
	 *
	 * @param leaseType dhcpの払い出し状態
	 */
	public void setLeaseType(String leaseType) {
		this.leaseType = leaseType;
	}

	/**
	 * dhcpの払い出し状態を設定し、自オブジェクトを返します。
	 *
	 * @param leaseType dhcpの払い出し状態
	 * @return 自オブジェクト
	 */
	public DhcpIpAddress withLeaseType(String leaseType) {
		setLeaseType(leaseType);
		return this;
	}

	/**
	 * IPアドレスリリース日を取得します。
	 *
	 * @return IPアドレスリリース日
	 */
	public Date getLeaseExpiration() {
		return leaseExpiration;
	}

	/**
	 * IPアドレスリリース日を設定します。
	 *
	 * @param leaseExpiration IPアドレスリリース日
	 */
	public void setLeaseExpiration(Date leaseExpiration) {
		this.leaseExpiration = leaseExpiration;
	}

	/**
	 * IPアドレスリリース日を設定し、自オブジェクトを返します。
	 *
	 * @param leaseExpiration IPアドレスリリース日
	 * @return 自オブジェクト
	 */
	public DhcpIpAddress withLeaseExpiration(Date leaseExpiration) {
		setLeaseExpiration(leaseExpiration);
		return this;
	}

	/**
	 * IPアドレスが設定されているリソース名を取得します。
	 *
	 * @return IPアドレスが設定されているリソース名
	 */
	public String getClientName() {
		return clientName;
	}

	/**
	 * IPアドレスが設定されているリソース名を設定します。
	 *
	 * @param clientName IPアドレスが設定されているリソース名
	 */
	public void setClientName(String clientName) {
		this.clientName = clientName;
	}

	/**
	 * IPアドレスが設定されているリソース名を設定し、自オブジェクトを返します。
	 *
	 * @param clientName IPアドレスが設定されているリソース名
	 * @return 自オブジェクト
	 */
	public DhcpIpAddress withClientName(String clientName) {
		setClientName(clientName);
		return this;
	}

	/**
	 * StaticMappingのメモ(500字,CDATAつき)を取得します。
	 *
	 * @return StaticMappingのメモ(500字,CDATAつき)
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * StaticMappingのメモ(500字,CDATAつき)を設定します。
	 *
	 * @param description StaticMappingのメモ(500字,CDATAつき)
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * StaticMappingのメモ(500字,CDATAつき)を設定し、自オブジェクトを返します。
	 *
	 * @param description StaticMappingのメモ(500字,CDATAつき)
	 * @return 自オブジェクト
	 */
	public DhcpIpAddress withDescription(String description) {
		setDescription(description);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[ipAddress=");
		builder.append(ipAddress);
		builder.append(", macAddress=");
		builder.append(macAddress);
		builder.append(", leaseType=");
		builder.append(leaseType);
		builder.append(", leaseExpiration=");
		builder.append(leaseExpiration);
		builder.append(", clientName=");
		builder.append(clientName);
		builder.append(", description=");
		builder.append(description);
		builder.append("]");
		return builder.toString();
	}
}
