/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.dhcp.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.dhcp.model.transform.DescribeDhcpOptionsResultConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * DescribeDhcpOptions処理結果クラス。<br />
 * このクラスはDescribeDhcpOptionsのレスポンスを格納します。
 */
@XStreamAlias("DescribeDhcpOptionsResponse")
@XStreamConverter(DescribeDhcpOptionsResultConverter.class)
public class DescribeDhcpOptionsResult extends Result {

	/** リクエスト識別子 */
	private String requestId;

	/** DHCPオプション情報リスト */
	private List<DhcpOptions> dhcpOptionsSet;

	/**
	 * リクエスト識別子を取得します。
	 *
	 * @return リクエスト識別子
	 */
	public String getRequestId() {
		return requestId;
	}

	/**
	 * リクエスト識別子を設定します。
	 *
	 * @param requestId リクエスト識別子
	 */
	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	/**
	 * リクエスト識別子を設定し、自オブジェクトを返します。
	 *
	 * @param requestId リクエスト識別子
	 * @return 自オブジェクト
	 */
	public DescribeDhcpOptionsResult withRequestId(String requestId) {
		setRequestId(requestId);
		return this;
	}

	/**
	 * DHCPオプション情報リストを取得します。
	 *
	 * @return DHCPオプション情報リスト
	 */
	public List<DhcpOptions> getDhcpOptionsSet() {
		return dhcpOptionsSet;
	}

	/**
	 * DHCPオプション情報リストを設定します。
	 *
	 * @param dhcpOptionsSet DHCPオプション情報リスト
	 */
	public void setDhcpOptionsSet(List<DhcpOptions> dhcpOptionsSet) {
		this.dhcpOptionsSet = dhcpOptionsSet;
	}

	/**
	 * DHCPオプション情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param dhcpOptionsSet DHCPオプション情報の配列
	 * @return 自オブジェクト
	 */
	public DescribeDhcpOptionsResult withDhcpOptionsSet(DhcpOptions ... dhcpOptionsSet) {
		if (this.dhcpOptionsSet == null) this.dhcpOptionsSet = new ArrayList<DhcpOptions>();
		for (DhcpOptions dhcpOptions : dhcpOptionsSet) {
			getDhcpOptionsSet().add(dhcpOptions);
		}
		return this;
	}

	/**
	 * DHCPオプション情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param dhcpOptionsSet DHCPオプション情報リスト
	 * @return 自オブジェクト
	 */
	public DescribeDhcpOptionsResult withDhcpOptionsSet(Collection<DhcpOptions> dhcpOptionsSet) {
		if (this.dhcpOptionsSet == null) this.dhcpOptionsSet = new ArrayList<DhcpOptions>();
		if (dhcpOptionsSet != null) {
			getDhcpOptionsSet().addAll(dhcpOptionsSet);
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[requestId=");
		builder.append(requestId);
		builder.append(", dhcpOptionsSet=");
		builder.append(dhcpOptionsSet);
		builder.append("]");
		return builder.toString();
	}
}
