/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.dhcp.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * DescribeDhcpOptionsリクエストクラス。<br />
 * このクラスはDescribeDhcpOptionsへのリクエストを構築します。
 *
 */
@Action("DescribeDhcpOptions")
public class DescribeDhcpOptionsRequest implements Request {

	/** DHCPオプション情報リスト */
	private List<DhcpOptionsIdSet> dhcpOptionsSet;

	/** 絞り込み情報リスト */
	private List<Filter> filters;

	/**
	 * DHCPオプション情報リストを取得します。
	 *
	 * @return DHCPオプション情報リスト
	 */
	@Query(name="")
	public List<DhcpOptionsIdSet> getDhcpOptionsSet() {
		return dhcpOptionsSet;
	}

	/**
	 * DHCPオプション情報リストを設定します。
	 *
	 * @param dhcpOptionsSet DHCPオプション情報リスト
	 */
	public void setDhcpOptionsSet(List<DhcpOptionsIdSet> dhcpOptionsSet) {
		this.dhcpOptionsSet = dhcpOptionsSet;
	}

	/**
	 * DHCPオプション情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param dhcpOptionsSet DHCPオプション情報の配列
	 * @return 自オブジェクト
	 */
	public DescribeDhcpOptionsRequest withDhcpOptionsSet(DhcpOptionsIdSet ... dhcpOptionsSet) {
		if (this.dhcpOptionsSet == null) this.dhcpOptionsSet = new ArrayList<DhcpOptionsIdSet>();
		for (DhcpOptionsIdSet dhcpOptions : dhcpOptionsSet) {
			getDhcpOptionsSet().add(dhcpOptions);
		}
		return this;
	}

	/**
	 * DHCPオプション情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param dhcpOptionsSet DHCPオプション情報リスト
	 * @return 自オブジェクト
	 */
	public DescribeDhcpOptionsRequest withDhcpOptionsSet(Collection<DhcpOptionsIdSet> dhcpOptionsSet) {
		if (this.dhcpOptionsSet == null) this.dhcpOptionsSet = new ArrayList<DhcpOptionsIdSet>();
		if (dhcpOptionsSet != null) {
			getDhcpOptionsSet().addAll(dhcpOptionsSet);
		}
		return this;
	}

	/**
	 * 絞り込み情報リストを取得します。
	 *
	 * @return 絞り込み情報リスト
	 */
	@Query(name="Filter")
	public List<Filter> getFilters() {
		return filters;
	}

	/**
	 * 絞り込み情報リストを設定します。
	 *
	 * @param filters 絞り込み情報リスト
	 */
	public void setFilters(List<Filter> filters) {
		this.filters = filters;
	}

	/**
	 * 絞り込み情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param filters 絞り込み情報の配列
	 * @return 自オブジェクト
	 */
	public DescribeDhcpOptionsRequest withFilters(Filter ... filters) {
		if (this.filters == null) this.filters = new ArrayList<Filter>();
		for (Filter filter : filters) {
			getFilters().add(filter);
		}
		return this;
	}

	/**
	 * 絞り込み情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param filters 絞り込み情報リスト
	 * @return 自オブジェクト
	 */
	public DescribeDhcpOptionsRequest withFilters(Collection<Filter> filters) {
		if (this.filters == null) this.filters = new ArrayList<Filter>();
		if (filters != null) {
			getFilters().addAll(filters);
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[dhcpOptionsSet=");
		builder.append(dhcpOptionsSet);
		builder.append(", filters=");
		builder.append(filters);
		builder.append("]");
		return builder.toString();
	}
}
