/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.dhcp.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * DeleteDhcpOptionsリクエストクラス。<br />
 * このクラスはDeleteDhcpOptionsへのリクエストを構築します。
 *
 */
@Action("DeleteDhcpOptions")
public class DeleteDhcpOptionsRequest implements Request {

	/** DHCPオプションID */
	private String dhcpOptionsId;

	/**
	 * デフォルトコンストラクタ。
	 */
	public DeleteDhcpOptionsRequest() {
	}

	/**
	 * DHCPオプションIDを指定し、DeleteDhcpOptionsRequestを構築します。
	 *
	 * @param dhcpOptionsId DHCPオプションID
	 */
	public DeleteDhcpOptionsRequest(String dhcpOptionsId) {
		this.dhcpOptionsId = dhcpOptionsId;
	}

	/**
	 * DHCPオプションIDを取得します。
	 *
	 * @return DHCPオプションID
	 */
	@Query(name="DhcpOptionsId", require=true)
	public String getDhcpOptionsId() {
		return dhcpOptionsId;
	}

	/**
	 * DHCPオプションIDを設定します。
	 *
	 * @param dhcpOptionsId DHCPオプションID
	 */
	public void setDhcpOptionsId(String dhcpOptionsId) {
		this.dhcpOptionsId = dhcpOptionsId;
	}

	/**
	 * DHCPオプションIDを設定し、自オブジェクトを返します。
	 *
	 * @param dhcpOptionsId DHCPオプションID
	 * @return 自オブジェクト
	 */
	public DeleteDhcpOptionsRequest withDhcpOptionsId(String dhcpOptionsId) {
		setDhcpOptionsId(dhcpOptionsId);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[dhcpOptionsId=");
		builder.append(dhcpOptionsId);
		builder.append("]");
		return builder.toString();
	}
}
