/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.dhcp;

import com.nifty.cloud.sdk.BaseClient;
import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.dhcp.model.CreateDhcpOptionsRequest;
import com.nifty.cloud.sdk.dhcp.model.CreateDhcpOptionsResult;
import com.nifty.cloud.sdk.dhcp.model.DeleteDhcpOptionsRequest;
import com.nifty.cloud.sdk.dhcp.model.DeleteDhcpOptionsResult;
import com.nifty.cloud.sdk.dhcp.model.DescribeDhcpOptionsRequest;
import com.nifty.cloud.sdk.dhcp.model.DescribeDhcpOptionsResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyCreateDhcpConfigRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyCreateDhcpConfigResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyCreateDhcpIpAddressPoolRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyCreateDhcpIpAddressPoolResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyCreateDhcpStaticMappingRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyCreateDhcpStaticMappingResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyDeleteDhcpConfigRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyDeleteDhcpConfigResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyDeleteDhcpIpAddressPoolRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyDeleteDhcpIpAddressPoolResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyDeleteDhcpStaticMappingRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyDeleteDhcpStaticMappingResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyDescribeDhcpConfigsRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyDescribeDhcpConfigsResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyDescribeDhcpStatusRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyDescribeDhcpStatusResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyDisableDhcpRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyDisableDhcpResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyEnableDhcpRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyEnableDhcpResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyReplaceDhcpConfigRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyReplaceDhcpConfigResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyReplaceDhcpOptionRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyReplaceDhcpOptionResult;

/**
 * NIFCLOUD API クライアント　具象クラス。
 * DHCPカテゴリ クライアント。<br />
 * DHCP カテゴリの同期クライアントの具象クラスです。
 *
 */
public class NiftyDhcpClient extends BaseClient implements NiftyDhcp {

	/**
	 * 認証情報を指定し、DHCPカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 */
	public NiftyDhcpClient(Credentials credential) {
		super(credential, new ClientConfiguration());
	}

	/**
	 * 認証情報、クライアント設定を指定し、DHCPカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 * @param configuration クライアント設定
	 */
	public NiftyDhcpClient(Credentials credential, ClientConfiguration configuration) {
		super(credential, configuration);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.dhcp.NiftyDhcp#niftyEnableDhcp(com.nifty.cloud.sdk.dhcp.model.NiftyEnableDhcpRequest)
	 */
	@Override
	public NiftyEnableDhcpResult niftyEnableDhcp(NiftyEnableDhcpRequest request) {
		return (NiftyEnableDhcpResult) client.execute(request, NiftyEnableDhcpResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.dhcp.NiftyDhcp#niftyDisableDhcp(com.nifty.cloud.sdk.dhcp.model.NiftyDisableDhcpRequest)
	 */
	@Override
	public NiftyDisableDhcpResult niftyDisableDhcp(NiftyDisableDhcpRequest request) {
		return (NiftyDisableDhcpResult) client.execute(request, NiftyDisableDhcpResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.dhcp.NiftyDhcp#createDhcpOptions(com.nifty.cloud.sdk.dhcp.model.CreateDhcpOptionsRequest)
	 */
	@Override
	public CreateDhcpOptionsResult createDhcpOptions(CreateDhcpOptionsRequest request) {
		return (CreateDhcpOptionsResult) client.execute(request, CreateDhcpOptionsResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.dhcp.NiftyDhcp#deleteDhcpOptions(com.nifty.cloud.sdk.dhcp.model.DeleteDhcpOptionsRequest)
	 */
	@Override
	public DeleteDhcpOptionsResult deleteDhcpOptions(DeleteDhcpOptionsRequest request) {
		return (DeleteDhcpOptionsResult) client.execute(request, DeleteDhcpOptionsResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.dhcp.NiftyDhcp#describeDhcpOptions(com.nifty.cloud.sdk.dhcp.model.DescribeDhcpOptionsRequest)
	 */
	@Override
	public DescribeDhcpOptionsResult describeDhcpOptions(DescribeDhcpOptionsRequest request) {
		return (DescribeDhcpOptionsResult) client.execute(request, DescribeDhcpOptionsResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.dhcp.NiftyDhcp#niftyReplaceDhcpOption(com.nifty.cloud.sdk.dhcp.model.NiftyReplaceDhcpOptionRequest)
	 */
	@Override
	public NiftyReplaceDhcpOptionResult niftyReplaceDhcpOption(NiftyReplaceDhcpOptionRequest request) {
		return (NiftyReplaceDhcpOptionResult) client.execute(request, NiftyReplaceDhcpOptionResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.dhcp.NiftyDhcp#niftyDescribeDhcpStatus(com.nifty.cloud.sdk.dhcp.model.NiftyDescribeDhcpStatusRequest)
	 */
	@Override
	public NiftyDescribeDhcpStatusResult niftyDescribeDhcpStatus(NiftyDescribeDhcpStatusRequest request) {
		return (NiftyDescribeDhcpStatusResult) client.execute(request, NiftyDescribeDhcpStatusResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.dhcp.NiftyDhcp#niftyCreateDhcpConfig(com.nifty.cloud.sdk.dhcp.model.NiftyCreateDhcpConfigRequest)
	 */
	@Override
	public NiftyCreateDhcpConfigResult niftyCreateDhcpConfig(NiftyCreateDhcpConfigRequest request) {
		return (NiftyCreateDhcpConfigResult) client.execute(request, NiftyCreateDhcpConfigResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.dhcp.NiftyDhcp#niftyDeleteDhcpConfig(com.nifty.cloud.sdk.dhcp.model.NiftyDeleteDhcpConfigRequest)
	 */
	@Override
	public NiftyDeleteDhcpConfigResult niftyDeleteDhcpConfig(NiftyDeleteDhcpConfigRequest request) {
		return (NiftyDeleteDhcpConfigResult) client.execute(request, NiftyDeleteDhcpConfigResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.dhcp.NiftyDhcp#niftyDescribeDhcpConfigs(com.nifty.cloud.sdk.dhcp.model.NiftyDescribeDhcpConfigsRequest)
	 */
	@Override
	public NiftyDescribeDhcpConfigsResult niftyDescribeDhcpConfigs(NiftyDescribeDhcpConfigsRequest request) {
		return (NiftyDescribeDhcpConfigsResult) client.execute(request, NiftyDescribeDhcpConfigsResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.dhcp.NiftyDhcp#niftyReplaceDhcpConfig(com.nifty.cloud.sdk.dhcp.model.NiftyReplaceDhcpConfigRequest)
	 */
	@Override
	public NiftyReplaceDhcpConfigResult niftyReplaceDhcpConfig(NiftyReplaceDhcpConfigRequest request) {
		return (NiftyReplaceDhcpConfigResult) client.execute(request, NiftyReplaceDhcpConfigResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.dhcp.NiftyDhcp#niftyCreateDhcpStaticMapping(com.nifty.cloud.sdk.dhcp.model.NiftyCreateDhcpStaticMappingRequest)
	 */
	@Override
	public NiftyCreateDhcpStaticMappingResult niftyCreateDhcpStaticMapping(NiftyCreateDhcpStaticMappingRequest request) {
		return (NiftyCreateDhcpStaticMappingResult) client.execute(request, NiftyCreateDhcpStaticMappingResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.dhcp.NiftyDhcp#niftyDeleteDhcpStaticMapping(com.nifty.cloud.sdk.dhcp.model.NiftyDeleteDhcpStaticMappingRequest)
	 */
	@Override
	public NiftyDeleteDhcpStaticMappingResult niftyDeleteDhcpStaticMapping(NiftyDeleteDhcpStaticMappingRequest request) {
		return (NiftyDeleteDhcpStaticMappingResult) client.execute(request, NiftyDeleteDhcpStaticMappingResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.dhcp.NiftyDhcp#niftyCreateDhcpIpAddressPool(com.nifty.cloud.sdk.dhcp.model.NiftyCreateDhcpIpAddressPoolRequest)
	 */
	@Override
	public NiftyCreateDhcpIpAddressPoolResult niftyCreateDhcpIpAddressPool(NiftyCreateDhcpIpAddressPoolRequest request) {
		return (NiftyCreateDhcpIpAddressPoolResult) client.execute(request, NiftyCreateDhcpIpAddressPoolResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.dhcp.NiftyDhcp#niftyDeleteDhcpIpAddressPool(com.nifty.cloud.sdk.dhcp.model.NiftyDeleteDhcpIpAddressPoolRequest)
	 */
	@Override
	public NiftyDeleteDhcpIpAddressPoolResult niftyDeleteDhcpIpAddressPool(NiftyDeleteDhcpIpAddressPoolRequest request) {
		return (NiftyDeleteDhcpIpAddressPoolResult) client.execute(request, NiftyDeleteDhcpIpAddressPoolResult.class);
	}
}