/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.dhcp;

import java.util.concurrent.Future;

import com.nifty.cloud.sdk.dhcp.model.CreateDhcpOptionsRequest;
import com.nifty.cloud.sdk.dhcp.model.CreateDhcpOptionsResult;
import com.nifty.cloud.sdk.dhcp.model.DeleteDhcpOptionsRequest;
import com.nifty.cloud.sdk.dhcp.model.DeleteDhcpOptionsResult;
import com.nifty.cloud.sdk.dhcp.model.DescribeDhcpOptionsRequest;
import com.nifty.cloud.sdk.dhcp.model.DescribeDhcpOptionsResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyCreateDhcpConfigRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyCreateDhcpConfigResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyCreateDhcpIpAddressPoolRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyCreateDhcpIpAddressPoolResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyCreateDhcpStaticMappingRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyCreateDhcpStaticMappingResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyDeleteDhcpConfigRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyDeleteDhcpConfigResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyDeleteDhcpIpAddressPoolRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyDeleteDhcpIpAddressPoolResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyDeleteDhcpStaticMappingRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyDeleteDhcpStaticMappingResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyDescribeDhcpConfigsRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyDescribeDhcpConfigsResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyDescribeDhcpStatusRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyDescribeDhcpStatusResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyDisableDhcpRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyDisableDhcpResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyEnableDhcpRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyEnableDhcpResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyReplaceDhcpConfigRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyReplaceDhcpConfigResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyReplaceDhcpOptionRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyReplaceDhcpOptionResult;


/**
 * NIFCLOUD API 非同期クライアント　インタフェース。
 * DHCPカテゴリクライアント。<br />
 * DHCP カテゴリの非同期クライアントのインタフェースです。
 *
 */
public interface NiftyDhcpAsync extends NiftyDhcp {

	/**
	 * 非同期でルーターに設定されたプライベートLANに対し、DHCP機能を有効化します。
	 *
	 * @param request NiftyEnableDhcpリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyEnableDhcpResult> niftyEnableDhcpAsync(NiftyEnableDhcpRequest request);


	/**
	 * 非同期でルーターに設定されたプライベートLANに対し、DHCP機能を無効化します。
	 *
	 * @param request NiftyDisableDhcpリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyDisableDhcpResult> niftyDisableDhcpAsync(NiftyDisableDhcpRequest request);


	/**
	 * 非同期でDHCPオプションの設定情報を新規作成します。
	 *
	 * @param request CreateDhcpOptionsリクエスト
	 * @return 非同期処理結果
	 */
	public Future<CreateDhcpOptionsResult> createDhcpOptionsAsync(CreateDhcpOptionsRequest request);


	/**
	 * 非同期で指定したDHCPオプションの設定情報を削除します。
	 *
	 * @param request DeleteDhcpOptionsリクエスト
	 * @return 非同期処理結果
	 */
	public Future<DeleteDhcpOptionsResult> deleteDhcpOptionsAsync(DeleteDhcpOptionsRequest request);


	/**
	 * 非同期でDHCPオプションの設定情報を取得します。
	 *
	 * @param request DescribeDhcpOptionsリクエスト
	 * @return 非同期処理結果
	 */
	public Future<DescribeDhcpOptionsResult> describeDhcpOptionsAsync(DescribeDhcpOptionsRequest request);


	/**
	 * 非同期でルーターに適用されたDHCPオプションを解除し、指定したDHCPオプションに入れ替えます。
	 *
	 * @param request NiftyReplaceDhcpOptionリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyReplaceDhcpOptionResult> niftyReplaceDhcpOptionAsync(NiftyReplaceDhcpOptionRequest request);


	/**
	 * 非同期でDHCPでのIP払い出し状態を取得します。
	 *
	 * @param request NiftyDescribeDhcpStatusリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyDescribeDhcpStatusResult> niftyDescribeDhcpStatusAsync(NiftyDescribeDhcpStatusRequest request);


	/**
	 * 非同期でDHCPコンフィグを新規作成します。
	 *
	 * @param request NiftyCreateDhcpConfigリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyCreateDhcpConfigResult> niftyCreateDhcpConfigAsync(NiftyCreateDhcpConfigRequest request);


	/**
	 * 非同期で指定したDHCPコンフィグを削除します。
	 *
	 * @param request NiftyDeleteDhcpConfigリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyDeleteDhcpConfigResult> niftyDeleteDhcpConfigAsync(NiftyDeleteDhcpConfigRequest request);


	/**
	 * 非同期でDHCPコンフィグ情報を取得します。
	 *
	 * @param request NiftyDescribeDhcpConfigsリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyDescribeDhcpConfigsResult> niftyDescribeDhcpConfigsAsync(NiftyDescribeDhcpConfigsRequest request);


	/**
	 * 非同期でDHCPコンフィグの入れ替えを実施します。
	 *
	 * @param request NiftyReplaceDhcpConfigリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyReplaceDhcpConfigResult> niftyReplaceDhcpConfigAsync(NiftyReplaceDhcpConfigRequest request);


	/**
	 * 非同期でDHCPコンフィグに手動割り当てIPアドレスの設定を追加します。
	 *
	 * @param request NiftyCreateDhcpStaticMappingリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyCreateDhcpStaticMappingResult> niftyCreateDhcpStaticMappingAsync(NiftyCreateDhcpStaticMappingRequest request);


	/**
	 * 非同期でDHCPコンフィグから手動割り当てIPアドレスの設定を削除します。
	 *
	 * @param request NiftyDeleteDhcpStaticMappingリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyDeleteDhcpStaticMappingResult> niftyDeleteDhcpStaticMappingAsync(NiftyDeleteDhcpStaticMappingRequest request);


	/**
	 * 非同期でDHCPコンフィグに自動割り当てIPアドレスの設定を追加します。
	 *
	 * @param request NiftyCreateDhcpIpAddressPoolリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyCreateDhcpIpAddressPoolResult> niftyCreateDhcpIpAddressPoolAsync(NiftyCreateDhcpIpAddressPoolRequest request);


	/**
	 * 非同期でDHCPコンフィグから自動割り当てIPアドレスの設定を削除します。
	 *
	 * @param request NiftyDeleteDhcpIpAddressPoolリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyDeleteDhcpIpAddressPoolResult> niftyDeleteDhcpIpAddressPoolAsync(NiftyDeleteDhcpIpAddressPoolRequest request);

}