/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.dhcp;

import com.nifty.cloud.sdk.dhcp.model.CreateDhcpOptionsRequest;
import com.nifty.cloud.sdk.dhcp.model.CreateDhcpOptionsResult;
import com.nifty.cloud.sdk.dhcp.model.DeleteDhcpOptionsRequest;
import com.nifty.cloud.sdk.dhcp.model.DeleteDhcpOptionsResult;
import com.nifty.cloud.sdk.dhcp.model.DescribeDhcpOptionsRequest;
import com.nifty.cloud.sdk.dhcp.model.DescribeDhcpOptionsResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyCreateDhcpConfigRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyCreateDhcpConfigResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyCreateDhcpIpAddressPoolRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyCreateDhcpIpAddressPoolResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyCreateDhcpStaticMappingRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyCreateDhcpStaticMappingResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyDeleteDhcpConfigRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyDeleteDhcpConfigResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyDeleteDhcpIpAddressPoolRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyDeleteDhcpIpAddressPoolResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyDeleteDhcpStaticMappingRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyDeleteDhcpStaticMappingResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyDescribeDhcpConfigsRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyDescribeDhcpConfigsResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyDescribeDhcpStatusRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyDescribeDhcpStatusResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyDisableDhcpRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyDisableDhcpResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyEnableDhcpRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyEnableDhcpResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyReplaceDhcpConfigRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyReplaceDhcpConfigResult;
import com.nifty.cloud.sdk.dhcp.model.NiftyReplaceDhcpOptionRequest;
import com.nifty.cloud.sdk.dhcp.model.NiftyReplaceDhcpOptionResult;


/**
 * NIFCLOUD API クライアント　インタフェース。
 * DHCP カテゴリ クライアント。<br />
 * DHCP カテゴリの同期クライアントのインタフェースです。
 *
 */
public interface NiftyDhcp {

	/**
	 * エンドポイントの設定を行います。
	 *
	 * @param endpoint エンドポイント
	 */
	public void setEndpoint(String endpoint);

	/**
	 * ルーターに設定されたプライベートLANに対し、DHCP機能を有効化します。
	 *
	 * @param request NiftyEnableDhcpリクエスト
	 * @return NiftyEnableDhcp処理結果
	 */
	public NiftyEnableDhcpResult niftyEnableDhcp(NiftyEnableDhcpRequest request);

	/**
	 * ルーターに設定されたプライベートLANに対し、DHCP機能を無効化します。
	 *
	 * @param request NiftyDisableDhcpリクエスト
	 * @return NiftyDisableDhcp処理結果
	 */
	public NiftyDisableDhcpResult niftyDisableDhcp(NiftyDisableDhcpRequest request);

	/**
	 * DHCPオプションの設定情報を新規作成します。
	 *
	 * @param request CreateDhcpOptionsリクエスト
	 * @return CreateDhcpOptions処理結果
	 */
	public CreateDhcpOptionsResult createDhcpOptions(CreateDhcpOptionsRequest request);

	/**
	 * 指定したDHCPオプションの設定情報を削除します。
	 *
	 * @param request DeleteDhcpOptionsリクエスト
	 * @return DeleteDhcpOptions処理結果
	 */
	public DeleteDhcpOptionsResult deleteDhcpOptions(DeleteDhcpOptionsRequest request);

	/**
	 * DHCPオプションの設定情報を取得します。
	 *
	 * @param request DescribeDhcpOptionsリクエスト
	 * @return DescribeDhcpOptions処理結果
	 */
	public DescribeDhcpOptionsResult describeDhcpOptions(DescribeDhcpOptionsRequest request);

	/**
	 * ルーターに適用されたDHCPオプションを解除し、指定したDHCPオプションに入れ替えます。
	 *
	 * @param request NiftyReplaceDhcpOptionリクエスト
	 * @return NiftyReplaceDhcpOption処理結果
	 */
	public NiftyReplaceDhcpOptionResult niftyReplaceDhcpOption(NiftyReplaceDhcpOptionRequest request);

	/**
	 * DHCPでのIP払い出し状態を取得します。
	 *
	 * @param request NiftyDescribeDhcpStatusリクエスト
	 * @return NiftyDescribeDhcpStatus処理結果
	 */
	public NiftyDescribeDhcpStatusResult niftyDescribeDhcpStatus(NiftyDescribeDhcpStatusRequest request);

	/**
	 * DHCPコンフィグを新規作成します。
	 *
	 * @param request NiftyCreateDhcpConfigリクエスト
	 * @return NiftyCreateDhcpConfig処理結果
	 */
	public NiftyCreateDhcpConfigResult niftyCreateDhcpConfig(NiftyCreateDhcpConfigRequest request);

	/**
	 * 指定したDHCPコンフィグを削除します。
	 *
	 * @param request NiftyDeleteDhcpConfigリクエスト
	 * @return NiftyDeleteDhcpConfig処理結果
	 */
	public NiftyDeleteDhcpConfigResult niftyDeleteDhcpConfig(NiftyDeleteDhcpConfigRequest request);

	/**
	 * DHCPコンフィグ情報を取得します。
	 *
	 * @param request NiftyDescribeDhcpConfigsリクエスト
	 * @return NiftyDescribeDhcpConfigs処理結果
	 */
	public NiftyDescribeDhcpConfigsResult niftyDescribeDhcpConfigs(NiftyDescribeDhcpConfigsRequest request);

	/**
	 * DHCPコンフィグの入れ替えを実施します。
	 *
	 * @param request NiftyReplaceDhcpConfigリクエスト
	 * @return NiftyReplaceDhcpConfig処理結果
	 */
	public NiftyReplaceDhcpConfigResult niftyReplaceDhcpConfig(NiftyReplaceDhcpConfigRequest request);

	/**
	 * DHCPコンフィグに手動割り当てIPアドレスの設定を追加します。
	 *
	 * @param request NiftyCreateDhcpStaticMappingリクエスト
	 * @return NiftyCreateDhcpStaticMapping処理結果
	 */
	public NiftyCreateDhcpStaticMappingResult niftyCreateDhcpStaticMapping(NiftyCreateDhcpStaticMappingRequest request);

	/**
	 * DHCPコンフィグから手動割り当てIPアドレスの設定を削除します。
	 *
	 * @param request NiftyDeleteDhcpStaticMappingリクエスト
	 * @return NiftyDeleteDhcpStaticMapping処理結果
	 */
	public NiftyDeleteDhcpStaticMappingResult niftyDeleteDhcpStaticMapping(NiftyDeleteDhcpStaticMappingRequest request);

	/**
	 * DHCPコンフィグに自動割り当てIPアドレスの設定を追加します。
	 *
	 * @param request NiftyCreateDhcpIpAddressPoolリクエスト
	 * @return NiftyCreateDhcpIpAddressPool処理結果
	 */
	public NiftyCreateDhcpIpAddressPoolResult niftyCreateDhcpIpAddressPool(NiftyCreateDhcpIpAddressPoolRequest request);

	/**
	 * DHCPコンフィグから自動割り当てIPアドレスの設定を削除します。
	 *
	 * @param request NiftyDeleteDhcpIpAddressPoolリクエスト
	 * @return NiftyDeleteDhcpIpAddressPool処理結果
	 */
	public NiftyDeleteDhcpIpAddressPoolResult niftyDeleteDhcpIpAddressPool(NiftyDeleteDhcpIpAddressPoolRequest request);
}