/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.dashboard.model;

/**
 * VPNゲートウェイ情報クラス。<br />
 * このクラスはVPNゲートウェイ情報を格納します。
 */
public class ResourceVpnGateway {

	/** VPNゲートウェイタイプ */
	private String type;

	/** VPNゲートウェイ数 */
	private Integer count;

	/**
	 * VPNゲートウェイタイプを取得します。
	 *
	 * @return VPNゲートウェイタイプ
	 */
	public String getType() {
		return type;
	}

	/**
	 * VPNゲートウェイタイプを設定します。
	 *
	 * @param type VPNゲートウェイタイプ
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * VPNゲートウェイタイプを設定し、自オブジェクトを返します。
	 *
	 * @param type VPNゲートウェイタイプ
	 * @return 自オブジェクト
	 */
	public ResourceVpnGateway withType(String type) {
		setType(type);
		return this;
	}

	/**
	 * VPNゲートウェイ数を取得します。
	 *
	 * @return VPNゲートウェイ数
	 */
	public Integer getCount() {
		return count;
	}

	/**
	 * VPNゲートウェイ数を設定します。
	 *
	 * @param count VPNゲートウェイ数
	 */
	public void setCount(Integer count) {
		this.count = count;
	}

	/**
	 * VPNゲートウェイ数を設定し、自オブジェクトを返します。
	 *
	 * @param count VPNゲートウェイ数
	 * @return 自オブジェクト
	 */
	public ResourceVpnGateway withCount(Integer count) {
		setCount(count);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[type=");
		builder.append(type);
		builder.append(", count=");
		builder.append(count);
		builder.append("]");
		return builder.toString();
	}
}
