/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.dashboard.model;

public class ResourceNetworkInterface {

    /** ネットワークインターフェースのタイプ */
    private String type;

    /** ネットワークインターフェースの利用数 */
    private Integer count;

    /**
     * ネットワークインターフェースのタイプを取得します。
     * 
     * @return ネットワークインターフェースのタイプ
     */
    public String getType() {
        return type;
    }

    /**
     * ネットワークインターフェースのタイプを設定します。
     * 
     * @param type
     *            ネットワークインターフェースのタイプ
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * ネットワークインターフェースのタイプを設定し、自オブジェクトを返します。
     * 
     * @param type
     *            ネットワークインターフェースのタイプ
     * @return 自オブジェクト
     */
    public ResourceNetworkInterface withType(String type) {
        setType(type);
        return this;
    }

    /**
     * ネットワークインターフェースの利用数を取得します。
     * 
     * @return ネットワークインターフェースの利用数
     */
    public Integer getCount() {
        return count;
    }

    /**
     * ネットワークインターフェースの利用数を設定します。
     * 
     * @param count
     *            ネットワークインターフェースの利用数
     */
    public void setCount(Integer count) {
        this.count = count;
    }

    /**
     * ネットワークインターフェースの利用数を設定し、自オブジェクトを返します。
     * 
     * @param count
     *            ネットワークインターフェースの利用数
     * @return 自オブジェクト
     */
    public ResourceNetworkInterface withCount(Integer count) {
        setCount(count);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[type=");
        builder.append(type);
        builder.append(", count=");
        builder.append(count);
        builder.append("]");
        return builder.toString();
    }
}
