/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.customergateway.model.transform;

import java.util.List;

import com.nifty.cloud.sdk.customergateway.model.CustomerGateway;
import com.nifty.cloud.sdk.customergateway.model.Tag;
import com.nifty.cloud.sdk.tools.DateUtils;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * CustomerGatewayType変換クラス。<br />
 * このクラスはレスポンスXMLのcustomerGateway要素からCustomerGatewayクラスを生成します。
 */
public class CustomerGatewayConverter implements Converter {

	private static final String ELEMENT_CUSTOMER_GATEWAY_ID = "customerGatewayId";
	private static final String ELEMENT_NIFTY_CUSTOMER_GATEWAY_NAME = "niftyCustomerGatewayName";
	private static final String ELEMENT_STATE = "state";
	private static final String ELEMENT_TYPE = "type";
	private static final String ELEMENT_IP_ADDRESS = "ipAddress";
	private static final String ELEMENT_NIFTY_LAN_SIDE_IP_ADDRESS = "niftyLanSideIpAddress";
	private static final String ELEMENT_NIFTY_LAN_SIDE_CIDR_BLOCK = "niftyLanSideCidrBlock";
	private static final String ELEMENT_BGP_ASN = "bgpAsn";
	private static final String ELEMENT_TAG_SET = "tagSet";
	private static final String ELEMENT_NIFTY_CUSTOMER_GATEWAY_DESCRIPTION = "niftyCustomerGatewayDescription";
	private static final String ELEMENT_CREATED_TIME = "createdTime";

	/**
	 * 変換可能なクラスか判定します。
	 *
	 * @param clazz クラス
	 * @return 変換可能な場合true, 変換不可能な場合false
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
	 */
	@SuppressWarnings("rawtypes")
	@Override
	public boolean canConvert(Class clazz) {
		return clazz == CustomerGateway.class;
	}

	/**
	 * {@literal
	 * customerGatewayをCustomerGatewayクラスに変換します。}
	 *
	 * @param reader XML読込リーダ
	 * @param context
	 * @return {@literal CustomerGatewayオブジェクト}
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader, UnmarshallingContext)
	 */
	@SuppressWarnings("unchecked")
	@Override
	public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
		CustomerGateway customerGateway = new CustomerGateway();
		Converter tagSetConverter = new TagSetConverter();

		String name = null;
		while (reader.hasMoreChildren()) {
			reader.moveDown();

			name = reader.getNodeName();
			if (name.equals(ELEMENT_CUSTOMER_GATEWAY_ID)) {
				customerGateway.setCustomerGatewayId(reader.getValue());
			} else if (name.equals(ELEMENT_NIFTY_CUSTOMER_GATEWAY_NAME)) {
				customerGateway.setNiftyCustomerGatewayName(reader.getValue());
			} else if (name.equals(ELEMENT_STATE)) {
				customerGateway.setState(reader.getValue());
			} else if (name.equals(ELEMENT_TYPE)) {
				customerGateway.setType(reader.getValue());
			} else if (name.equals(ELEMENT_IP_ADDRESS)) {
				customerGateway.setIpAddress(reader.getValue());
			} else if (name.equals(ELEMENT_NIFTY_LAN_SIDE_IP_ADDRESS)) {
				customerGateway.setNiftyLanSideIpAddress(reader.getValue());
			} else if (name.equals(ELEMENT_NIFTY_LAN_SIDE_CIDR_BLOCK)) {
				customerGateway.setNiftyLanSideCidrBlock(reader.getValue());
			} else if (name.equals(ELEMENT_BGP_ASN)) {
				customerGateway.setBgpAsn(reader.getValue());
			} else if (name.equals(ELEMENT_TAG_SET)) {
				customerGateway.setTagSet((List<Tag>) tagSetConverter.unmarshal(reader, context));
			} else if (name.equals(ELEMENT_NIFTY_CUSTOMER_GATEWAY_DESCRIPTION)) {
				customerGateway.setNiftyCustomerGatewayDescription(reader.getValue());
			} else if (name.equals(ELEMENT_CREATED_TIME)) {
				customerGateway.setCreatedTime(DateUtils.toDate(reader.getValue()));
			}

			reader.moveUp();
		}

		return customerGateway;
	}

	/**
	 * 未実装メソッド
	 */
	@Override
	public void marshal(Object paramObject,
			HierarchicalStreamWriter paramHierarchicalStreamWriter,
			MarshallingContext paramMarshallingContext) {
	}
}
