/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.customergateway.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyModifyCustomerGatewayAttributeリクエストクラス。<br />
 * このクラスはNiftyModifyCustomerGatewayAttributeへのリクエストを構築します。
 *
 */
@Action("NiftyModifyCustomerGatewayAttribute")
public class NiftyModifyCustomerGatewayAttributeRequest implements Request {

	/** カスタマーゲートウェイユニークID */
	private String customerGatewayId;

	/** カスタマーゲートウェイ名 */
	private String niftyCustomerGatewayName;

	/** 更新対象の項目名 */
	private String attribute;

	/** 更新値 */
	private String value;

	/**
	 * カスタマーゲートウェイユニークIDを取得します。
	 *
	 * @return カスタマーゲートウェイユニークID
	 */
	@Query(name="CustomerGatewayId")
	public String getCustomerGatewayId() {
		return customerGatewayId;
	}

	/**
	 * カスタマーゲートウェイユニークIDを設定します。
	 *
	 * @param customerGatewayId カスタマーゲートウェイユニークID
	 */
	public void setCustomerGatewayId(String customerGatewayId) {
		this.customerGatewayId = customerGatewayId;
	}

	/**
	 * カスタマーゲートウェイユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param customerGatewayId カスタマーゲートウェイユニークID
	 * @return 自オブジェクト
	 */
	public NiftyModifyCustomerGatewayAttributeRequest withCustomerGatewayId(String customerGatewayId) {
		setCustomerGatewayId(customerGatewayId);
		return this;
	}

	/**
	 * カスタマーゲートウェイ名を取得します。
	 *
	 * @return カスタマーゲートウェイ名
	 */
	@Query(name="NiftyCustomerGatewayName")
	public String getNiftyCustomerGatewayName() {
		return niftyCustomerGatewayName;
	}

	/**
	 * カスタマーゲートウェイ名を設定します。
	 *
	 * @param niftyCustomerGatewayName カスタマーゲートウェイ名
	 */
	public void setNiftyCustomerGatewayName(String niftyCustomerGatewayName) {
		this.niftyCustomerGatewayName = niftyCustomerGatewayName;
	}

	/**
	 * カスタマーゲートウェイ名を設定し、自オブジェクトを返します。
	 *
	 * @param niftyCustomerGatewayName カスタマーゲートウェイ名
	 * @return 自オブジェクト
	 */
	public NiftyModifyCustomerGatewayAttributeRequest withNiftyCustomerGatewayName(String niftyCustomerGatewayName) {
		setNiftyCustomerGatewayName(niftyCustomerGatewayName);
		return this;
	}

	/**
	 * 更新対象の項目名を取得します。
	 *
	 * @return 更新対象の項目名
	 */
	@Query(name="Attribute")
	public String getAttribute() {
		return attribute;
	}

	/**
	 * 更新対象の項目名を設定します。
	 *
	 * @param attribute 更新対象の項目名
	 */
	public void setAttribute(String attribute) {
		this.attribute = attribute;
	}

	/**
	 * 更新対象の項目名を設定し、自オブジェクトを返します。
	 *
	 * @param attribute 更新対象の項目名
	 * @return 自オブジェクト
	 */
	public NiftyModifyCustomerGatewayAttributeRequest withAttribute(String attribute) {
		setAttribute(attribute);
		return this;
	}

	/**
	 * 更新値を取得します。
	 *
	 * @return 更新値
	 */
	@Query(name="Value")
	public String getValue() {
		return value;
	}

	/**
	 * 更新値を設定します。
	 *
	 * @param value 更新値
	 */
	public void setValue(String value) {
		this.value = value;
	}

	/**
	 * 更新値を設定し、自オブジェクトを返します。
	 *
	 * @param value 更新値
	 * @return 自オブジェクト
	 */
	public NiftyModifyCustomerGatewayAttributeRequest withValue(String value) {
		setValue(value);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[customerGatewayId=");
		builder.append(customerGatewayId);
		builder.append(", niftyCustomerGatewayName=");
		builder.append(niftyCustomerGatewayName);
		builder.append(", attribute=");
		builder.append(attribute);
		builder.append(", value=");
		builder.append(value);
		builder.append("]");
		return builder.toString();
	}
}
