/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.customergateway.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.customergateway.model.transform.DescribeCustomerGatewaysResultConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * DescribeCustomerGateways処理結果クラス。<br />
 * このクラスはDescribeCustomerGatewaysのレスポンスを格納します。
 */
@XStreamAlias("DescribeCustomerGatewaysResponse")
@XStreamConverter(DescribeCustomerGatewaysResultConverter.class)
public class DescribeCustomerGatewaysResult extends Result {

	/** リクエスト識別子 */
	private String requestId;

	/** カスタマーゲートウェイ情報リスト */
	private List<CustomerGateway> customerGateways;

	/**
	 * リクエスト識別子を取得します。
	 *
	 * @return リクエスト識別子
	 */
	public String getRequestId() {
		return requestId;
	}

	/**
	 * リクエスト識別子を設定します。
	 *
	 * @param requestId リクエスト識別子
	 */
	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	/**
	 * リクエスト識別子を設定し、自オブジェクトを返します。
	 *
	 * @param requestId リクエスト識別子
	 * @return 自オブジェクト
	 */
	public DescribeCustomerGatewaysResult withRequestId(String requestId) {
		setRequestId(requestId);
		return this;
	}

	/**
	 * カスタマーゲートウェイ情報リストを取得します。
	 *
	 * @return カスタマーゲートウェイ情報リスト
	 */
	public List<CustomerGateway> getCustomerGateways() {
		return customerGateways;
	}

	/**
	 * カスタマーゲートウェイ情報リストを設定します。
	 *
	 * @param customerGateways カスタマーゲートウェイ情報リスト
	 */
	public void setCustomerGateways(List<CustomerGateway> customerGateways) {
		this.customerGateways = customerGateways;
	}

	/**
	 * カスタマーゲートウェイ情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param customerGateways カスタマーゲートウェイ情報の配列
	 * @return 自オブジェクト
	 */
	public DescribeCustomerGatewaysResult withCustomerGateways(CustomerGateway ... customerGateways) {
		if (this.customerGateways == null) this.customerGateways = new ArrayList<CustomerGateway>();
		for (CustomerGateway customerGateway : customerGateways) {
			getCustomerGateways().add(customerGateway);
		}
		return this;
	}

	/**
	 * カスタマーゲートウェイ情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param customerGateways カスタマーゲートウェイ情報リスト
	 * @return 自オブジェクト
	 */
	public DescribeCustomerGatewaysResult withCustomerGateways(Collection<CustomerGateway> customerGateways) {
		if (this.customerGateways == null) this.customerGateways = new ArrayList<CustomerGateway>();
		if (customerGateways != null) {
			getCustomerGateways().addAll(customerGateways);
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[requestId=");
		builder.append(requestId);
		builder.append(", customerGateways=");
		builder.append(customerGateways);
		builder.append("]");
		return builder.toString();
	}
}
