/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.customergateway.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * DeleteCustomerGatewayリクエストクラス。<br />
 * このクラスはDeleteCustomerGatewayへのリクエストを構築します。
 *
 */
@Action("DeleteCustomerGateway")
public class DeleteCustomerGatewayRequest implements Request {

	/** カスタマーゲートウェイユニークID */
	private String customerGatewayId;

	/** カスタマーゲートウェイ名 */
	private String niftyCustomerGatewayName;

	/**
	 * カスタマーゲートウェイユニークIDを取得します。
	 *
	 * @return カスタマーゲートウェイユニークID
	 */
	@Query(name="CustomerGatewayId")
	public String getCustomerGatewayId() {
		return customerGatewayId;
	}

	/**
	 * カスタマーゲートウェイユニークIDを設定します。
	 *
	 * @param customerGatewayId カスタマーゲートウェイユニークID
	 */
	public void setCustomerGatewayId(String customerGatewayId) {
		this.customerGatewayId = customerGatewayId;
	}

	/**
	 * カスタマーゲートウェイユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param customerGatewayId カスタマーゲートウェイユニークID
	 * @return 自オブジェクト
	 */
	public DeleteCustomerGatewayRequest withCustomerGatewayId(String customerGatewayId) {
		setCustomerGatewayId(customerGatewayId);
		return this;
	}

	/**
	 * カスタマーゲートウェイ名を取得します。
	 *
	 * @return カスタマーゲートウェイ名
	 */
	@Query(name="NiftyCustomerGatewayName")
	public String getNiftyCustomerGatewayName() {
		return niftyCustomerGatewayName;
	}

	/**
	 * カスタマーゲートウェイ名を設定します。
	 *
	 * @param niftyCustomerGatewayName カスタマーゲートウェイ名
	 */
	public void setNiftyCustomerGatewayName(String niftyCustomerGatewayName) {
		this.niftyCustomerGatewayName = niftyCustomerGatewayName;
	}

	/**
	 * カスタマーゲートウェイ名を設定し、自オブジェクトを返します。
	 *
	 * @param niftyCustomerGatewayName カスタマーゲートウェイ名
	 * @return 自オブジェクト
	 */
	public DeleteCustomerGatewayRequest withNiftyCustomerGatewayName(String niftyCustomerGatewayName) {
		setNiftyCustomerGatewayName(niftyCustomerGatewayName);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[customerGatewayId=");
		builder.append(customerGatewayId);
		builder.append(", niftyCustomerGatewayName=");
		builder.append(niftyCustomerGatewayName);
		builder.append("]");
		return builder.toString();
	}
}
