/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.customergateway.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/**
 * カスタマーゲートウェイ情報クラス。<br />
 * このクラスはカスタマーゲートウェイ情報を格納します。
 *
 */
public class CustomerGateway {

	/** カスタマーゲートウェイユニークID */
	private String customerGatewayId;

	/** カスタマーゲートウェイ名 */
	private String niftyCustomerGatewayName;

	/** カスタマーゲートウェイステータス */
	private String state;

	private String type;

	/** カスタマーゲートウェイのインターネット側IPアドレス/ドメイン */
	private String ipAddress;

	/** カスタマーゲートウェイ(対向機器)のLAN側IPアドレス */
	private String niftyLanSideIpAddress;

	/** カスタマーゲートウェイ(対向機器)のLAN側IPアドレス帯(CIDR) */
	private String niftyLanSideCidrBlock;

	private String bgpAsn;

	/** リソースに設定されているタグ情報 */
	private List<Tag> tagSet;

	/** メモ */
	private String niftyCustomerGatewayDescription;

	/** 作成日時 */
	private Date createdTime;

	/**
	 * カスタマーゲートウェイユニークIDを取得します。
	 *
	 * @return カスタマーゲートウェイユニークID
	 */
	public String getCustomerGatewayId() {
		return customerGatewayId;
	}

	/**
	 * カスタマーゲートウェイユニークIDを設定します。
	 *
	 * @param customerGatewayId カスタマーゲートウェイユニークID
	 */
	public void setCustomerGatewayId(String customerGatewayId) {
		this.customerGatewayId = customerGatewayId;
	}

	/**
	 * カスタマーゲートウェイユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param customerGatewayId カスタマーゲートウェイユニークID
	 * @return 自オブジェクト
	 */
	public CustomerGateway withCustomerGatewayId(String customerGatewayId) {
		setCustomerGatewayId(customerGatewayId);
		return this;
	}

	/**
	 * カスタマーゲートウェイ名を取得します。
	 *
	 * @return カスタマーゲートウェイ名
	 */
	public String getNiftyCustomerGatewayName() {
		return niftyCustomerGatewayName;
	}

	/**
	 * カスタマーゲートウェイ名を設定します。
	 *
	 * @param niftyCustomerGatewayName カスタマーゲートウェイ名
	 */
	public void setNiftyCustomerGatewayName(String niftyCustomerGatewayName) {
		this.niftyCustomerGatewayName = niftyCustomerGatewayName;
	}

	/**
	 * カスタマーゲートウェイ名を設定し、自オブジェクトを返します。
	 *
	 * @param niftyCustomerGatewayName カスタマーゲートウェイ名
	 * @return 自オブジェクト
	 */
	public CustomerGateway withNiftyCustomerGatewayName(String niftyCustomerGatewayName) {
		setNiftyCustomerGatewayName(niftyCustomerGatewayName);
		return this;
	}

	/**
	 * カスタマーゲートウェイステータスを取得します。
	 *
	 * @return カスタマーゲートウェイステータス
	 */
	public String getState() {
		return state;
	}

	/**
	 * カスタマーゲートウェイステータスを設定します。
	 *
	 * @param state カスタマーゲートウェイステータス
	 */
	public void setState(String state) {
		this.state = state;
	}

	/**
	 * カスタマーゲートウェイステータスを設定し、自オブジェクトを返します。
	 *
	 * @param state カスタマーゲートウェイステータス
	 * @return 自オブジェクト
	 */
	public CustomerGateway withState(String state) {
		setState(state);
		return this;
	}

	/**
	 * typeを取得します。
	 *
	 * @return type
	 */
	public String getType() {
		return type;
	}

	/**
	 * typeを設定します。
	 *
	 * @param type
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * typeを設定し、自オブジェクトを返します。
	 *
	 * @param type
	 * @return 自オブジェクト
	 */
	public CustomerGateway withType(String type) {
		setType(type);
		return this;
	}

	/**
	 * カスタマーゲートウェイのインターネット側IPアドレス/ドメインを取得します。
	 *
	 * @return カスタマーゲートウェイのインターネット側IPアドレス/ドメイン
	 */
	public String getIpAddress() {
		return ipAddress;
	}

	/**
	 * カスタマーゲートウェイのインターネット側IPアドレス/ドメインを設定します。
	 *
	 * @param ipAddress カスタマーゲートウェイのインターネット側IPアドレス/ドメイン
	 */
	public void setIpAddress(String ipAddress) {
		this.ipAddress = ipAddress;
	}

	/**
	 * カスタマーゲートウェイのインターネット側IPアドレス/ドメインを設定し、自オブジェクトを返します。
	 *
	 * @param ipAddress カスタマーゲートウェイのインターネット側IPアドレス/ドメイン
	 * @return 自オブジェクト
	 */
	public CustomerGateway withIpAddress(String ipAddress) {
		setIpAddress(ipAddress);
		return this;
	}

	/**
	 * カスタマーゲートウェイ(対向機器)のLAN側IPアドレスを取得します。
	 *
	 * @return カスタマーゲートウェイ(対向機器)のLAN側IPアドレス
	 */
	public String getNiftyLanSideIpAddress() {
		return niftyLanSideIpAddress;
	}

	/**
	 * カスタマーゲートウェイ(対向機器)のLAN側IPアドレスを設定します。
	 *
	 * @param niftyLanSideIpAddress カスタマーゲートウェイ(対向機器)のLAN側IPアドレス
	 */
	public void setNiftyLanSideIpAddress(String niftyLanSideIpAddress) {
		this.niftyLanSideIpAddress = niftyLanSideIpAddress;
	}

	/**
	 * カスタマーゲートウェイ(対向機器)のLAN側IPアドレスを設定し、自オブジェクトを返します。
	 *
	 * @param niftyLanSideIpAddress カスタマーゲートウェイ(対向機器)のLAN側IPアドレス
	 * @return 自オブジェクト
	 */
	public CustomerGateway withNiftyLanSideIpAddress(String niftyLanSideIpAddress) {
		setNiftyLanSideIpAddress(niftyLanSideIpAddress);
		return this;
	}

	/**
	 * カスタマーゲートウェイ(対向機器)のLAN側IPアドレス帯(CIDR)を取得します。
	 *
	 * @return カスタマーゲートウェイ(対向機器)のLAN側IPアドレス帯(CIDR)
	 */
	public String getNiftyLanSideCidrBlock() {
		return niftyLanSideCidrBlock;
	}

	/**
	 * カスタマーゲートウェイ(対向機器)のLAN側IPアドレス帯(CIDR)を設定します。
	 *
	 * @param niftyLanSideCidrBlock カスタマーゲートウェイ(対向機器)のLAN側IPアドレス帯(CIDR)
	 */
	public void setNiftyLanSideCidrBlock(String niftyLanSideCidrBlock) {
		this.niftyLanSideCidrBlock = niftyLanSideCidrBlock;
	}

	/**
	 * カスタマーゲートウェイ(対向機器)のLAN側IPアドレス帯(CIDR)を設定し、自オブジェクトを返します。
	 *
	 * @param niftyLanSideCidrBlock カスタマーゲートウェイ(対向機器)のLAN側IPアドレス帯(CIDR)
	 * @return 自オブジェクト
	 */
	public CustomerGateway withNiftyLanSideCidrBlock(String niftyLanSideCidrBlock) {
		setNiftyLanSideCidrBlock(niftyLanSideCidrBlock);
		return this;
	}

	/**
	 * bgpAsnを取得します。
	 *
	 * @return bgpAsn
	 */
	public String getBgpAsn() {
		return bgpAsn;
	}

	/**
	 * bgpAsnを設定します。
	 *
	 * @param bgpAsn
	 */
	public void setBgpAsn(String bgpAsn) {
		this.bgpAsn = bgpAsn;
	}

	/**
	 * bgpAsnを設定し、自オブジェクトを返します。
	 *
	 * @param bgpAsn
	 * @return 自オブジェクト
	 */
	public CustomerGateway withBgpAsn(String bgpAsn) {
		setBgpAsn(bgpAsn);
		return this;
	}

	/**
	 * リソースに設定されているタグ情報を取得します。
	 *
	 * @return リソースに設定されているタグ情報
	 */
	public List<Tag> getTagSet() {
		return tagSet;
	}

	/**
	 * リソースに設定されているタグ情報を設定します。
	 *
	 * @param tagSet リソースに設定されているタグ情報
	 */
	public void setTagSet(List<Tag> tagSet) {
		this.tagSet = tagSet;
	}

	/**
	 * リソースに設定されているタグ情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param tagSet リソースに設定されているタグ情報の配列
	 * @return 自オブジェクト
	 */
	public CustomerGateway withTagSet(Tag ... tagSet) {
		if (this.tagSet == null) this.tagSet = new ArrayList<Tag>();
		for (Tag tag : tagSet) {
			getTagSet().add(tag);
		}
		return this;
	}

	/**
	 * リソースに設定されているタグ情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param tagSet リソースに設定されているタグ情報リスト
	 * @return 自オブジェクト
	 */
	public CustomerGateway withTagSet(Collection<Tag> tagSet) {
		if (this.tagSet == null) this.tagSet = new ArrayList<Tag>();
		if (tagSet != null) {
			getTagSet().addAll(tagSet);
		}
		return this;
	}

	/**
	 * メモを取得します。
	 *
	 * @return メモ
	 */
	public String getNiftyCustomerGatewayDescription() {
		return niftyCustomerGatewayDescription;
	}

	/**
	 * メモを設定します。
	 *
	 * @param niftyCustomerGatewayDescription メモ
	 */
	public void setNiftyCustomerGatewayDescription(String niftyCustomerGatewayDescription) {
		this.niftyCustomerGatewayDescription = niftyCustomerGatewayDescription;
	}

	/**
	 * メモを設定し、自オブジェクトを返します。
	 *
	 * @param niftyCustomerGatewayDescription メモ
	 * @return 自オブジェクト
	 */
	public CustomerGateway withNiftyCustomerGatewayDescription(String niftyCustomerGatewayDescription) {
		setNiftyCustomerGatewayDescription(niftyCustomerGatewayDescription);
		return this;
	}

	/**
	 * 作成日時を取得します。
	 *
	 * @return 作成日時
	 */
	public Date getCreatedTime() {
		return createdTime;
	}

	/**
	 * 作成日時を設定します。
	 *
	 * @param createdTime 作成日時
	 */
	public void setCreatedTime(Date createdTime) {
		this.createdTime = createdTime;
	}

	/**
	 * 作成日時を設定し、自オブジェクトを返します。
	 *
	 * @param createdTime 作成日時
	 * @return 自オブジェクト
	 */
	public CustomerGateway withCreatedTime(Date createdTime) {
		setCreatedTime(createdTime);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[customerGatewayId=");
		builder.append(customerGatewayId);
		builder.append(", niftyCustomerGatewayName=");
		builder.append(niftyCustomerGatewayName);
		builder.append(", state=");
		builder.append(state);
		builder.append(", type=");
		builder.append(type);
		builder.append(", ipAddress=");
		builder.append(ipAddress);
		builder.append(", niftyLanSideIpAddress=");
		builder.append(niftyLanSideIpAddress);
		builder.append(", niftyLanSideCidrBlock=");
		builder.append(niftyLanSideCidrBlock);
		builder.append(", bgpAsn=");
		builder.append(bgpAsn);
		builder.append(", tagSet=");
		builder.append(tagSet);
		builder.append(", niftyCustomerGatewayDescription=");
		builder.append(niftyCustomerGatewayDescription);
		builder.append(", createdTime=");
		builder.append(createdTime);
		builder.append("]");
		return builder.toString();
	}
}
