/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.customergateway.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * CreateCustomerGatewayリクエストクラス。<br />
 * このクラスはCreateCustomerGatewayへのリクエストを構築します。
 *
 */
@Action("CreateCustomerGateway")
public class CreateCustomerGatewayRequest implements Request {

	private String type;

	/** カスタマーゲートウェイのインターネット側IPアドレス/ドメイン */
	private String ipAddress;

	private String bgpAsn;

	/** カスタマーゲートウェイ名 */
	private String niftyCustomerGatewayName;

	/** カスタマーゲートウェイ(対向機器)のLAN側IPアドレス */
	private String niftyLanSideIpAddress;

	/** カスタマーゲートウェイ(対向機器)のLAN側IPアドレス帯(CIDR) */
	private String niftyLanSideCidrBlock;

	/** メモ */
	private String niftyCustomerGatewayDescription;

	/**
	 * デフォルトコンストラクタ。
	 */
	public CreateCustomerGatewayRequest() {
	}

	/**
	 * カスタマーゲートウェイのインターネット側IPアドレス/ドメインを指定し、CreateCustomerGatewayRequestを構築します。
	 *
	 * @param ipAddress カスタマーゲートウェイのインターネット側IPアドレス/ドメイン
	 */
	public CreateCustomerGatewayRequest(String ipAddress) {
		this.ipAddress = ipAddress;
	}

	/**
	 * typeを取得します。
	 *
	 * @return type
	 */
	@Query(name="Type")
	public String getType() {
		return type;
	}

	/**
	 * typeを設定します。
	 *
	 * @param type
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * typeを設定し、自オブジェクトを返します。
	 *
	 * @param type
	 * @return 自オブジェクト
	 */
	public CreateCustomerGatewayRequest withType(String type) {
		setType(type);
		return this;
	}

	/**
	 * カスタマーゲートウェイのインターネット側IPアドレス/ドメインを取得します。
	 *
	 * @return カスタマーゲートウェイのインターネット側IPアドレス/ドメイン
	 */
	@Query(name="IpAddress", require=true)
	public String getIpAddress() {
		return ipAddress;
	}

	/**
	 * カスタマーゲートウェイのインターネット側IPアドレス/ドメインを設定します。
	 *
	 * @param ipAddress カスタマーゲートウェイのインターネット側IPアドレス/ドメイン
	 */
	public void setIpAddress(String ipAddress) {
		this.ipAddress = ipAddress;
	}

	/**
	 * カスタマーゲートウェイのインターネット側IPアドレス/ドメインを設定し、自オブジェクトを返します。
	 *
	 * @param ipAddress カスタマーゲートウェイのインターネット側IPアドレス/ドメイン
	 * @return 自オブジェクト
	 */
	public CreateCustomerGatewayRequest withIpAddress(String ipAddress) {
		setIpAddress(ipAddress);
		return this;
	}

	/**
	 * bgpAsnを取得します。
	 *
	 * @return bgpAsn
	 */
	@Query(name="BgpAsn")
	public String getBgpAsn() {
		return bgpAsn;
	}

	/**
	 * bgpAsnを設定します。
	 *
	 * @param bgpAsn
	 */
	public void setBgpAsn(String bgpAsn) {
		this.bgpAsn = bgpAsn;
	}

	/**
	 * bgpAsnを設定し、自オブジェクトを返します。
	 *
	 * @param bgpAsn
	 * @return 自オブジェクト
	 */
	public CreateCustomerGatewayRequest withBgpAsn(String bgpAsn) {
		setBgpAsn(bgpAsn);
		return this;
	}

	/**
	 * カスタマーゲートウェイ名を取得します。
	 *
	 * @return カスタマーゲートウェイ名
	 */
	@Query(name="NiftyCustomerGatewayName")
	public String getNiftyCustomerGatewayName() {
		return niftyCustomerGatewayName;
	}

	/**
	 * カスタマーゲートウェイ名を設定します。
	 *
	 * @param niftyCustomerGatewayName カスタマーゲートウェイ名
	 */
	public void setNiftyCustomerGatewayName(String niftyCustomerGatewayName) {
		this.niftyCustomerGatewayName = niftyCustomerGatewayName;
	}

	/**
	 * カスタマーゲートウェイ名を設定し、自オブジェクトを返します。
	 *
	 * @param niftyCustomerGatewayName カスタマーゲートウェイ名
	 * @return 自オブジェクト
	 */
	public CreateCustomerGatewayRequest withNiftyCustomerGatewayName(String niftyCustomerGatewayName) {
		setNiftyCustomerGatewayName(niftyCustomerGatewayName);
		return this;
	}

	/**
	 * カスタマーゲートウェイ(対向機器)のLAN側IPアドレスを取得します。
	 *
	 * @return カスタマーゲートウェイ(対向機器)のLAN側IPアドレス
	 */
	@Query(name="NiftyLanSideIpAddress")
	public String getNiftyLanSideIpAddress() {
		return niftyLanSideIpAddress;
	}

	/**
	 * カスタマーゲートウェイ(対向機器)のLAN側IPアドレスを設定します。
	 *
	 * @param niftyLanSideIpAddress カスタマーゲートウェイ(対向機器)のLAN側IPアドレス
	 */
	public void setNiftyLanSideIpAddress(String niftyLanSideIpAddress) {
		this.niftyLanSideIpAddress = niftyLanSideIpAddress;
	}

	/**
	 * カスタマーゲートウェイ(対向機器)のLAN側IPアドレスを設定し、自オブジェクトを返します。
	 *
	 * @param niftyLanSideIpAddress カスタマーゲートウェイ(対向機器)のLAN側IPアドレス
	 * @return 自オブジェクト
	 */
	public CreateCustomerGatewayRequest withNiftyLanSideIpAddress(String niftyLanSideIpAddress) {
		setNiftyLanSideIpAddress(niftyLanSideIpAddress);
		return this;
	}

	/**
	 * カスタマーゲートウェイ(対向機器)のLAN側IPアドレス帯(CIDR)を取得します。
	 *
	 * @return カスタマーゲートウェイ(対向機器)のLAN側IPアドレス帯(CIDR)
	 */
	@Query(name="NiftyLanSideCidrBlock")
	public String getNiftyLanSideCidrBlock() {
		return niftyLanSideCidrBlock;
	}

	/**
	 * カスタマーゲートウェイ(対向機器)のLAN側IPアドレス帯(CIDR)を設定します。
	 *
	 * @param niftyLanSideCidrBlock カスタマーゲートウェイ(対向機器)のLAN側IPアドレス帯(CIDR)
	 */
	public void setNiftyLanSideCidrBlock(String niftyLanSideCidrBlock) {
		this.niftyLanSideCidrBlock = niftyLanSideCidrBlock;
	}

	/**
	 * カスタマーゲートウェイ(対向機器)のLAN側IPアドレス帯(CIDR)を設定し、自オブジェクトを返します。
	 *
	 * @param niftyLanSideCidrBlock カスタマーゲートウェイ(対向機器)のLAN側IPアドレス帯(CIDR)
	 * @return 自オブジェクト
	 */
	public CreateCustomerGatewayRequest withNiftyLanSideCidrBlock(String niftyLanSideCidrBlock) {
		setNiftyLanSideCidrBlock(niftyLanSideCidrBlock);
		return this;
	}

	/**
	 * メモを取得します。
	 *
	 * @return メモ
	 */
	@Query(name="NiftyCustomerGatewayDescription")
	public String getNiftyCustomerGatewayDescription() {
		return niftyCustomerGatewayDescription;
	}

	/**
	 * メモを設定します。
	 *
	 * @param niftyCustomerGatewayDescription メモ
	 */
	public void setNiftyCustomerGatewayDescription(String niftyCustomerGatewayDescription) {
		this.niftyCustomerGatewayDescription = niftyCustomerGatewayDescription;
	}

	/**
	 * メモを設定し、自オブジェクトを返します。
	 *
	 * @param niftyCustomerGatewayDescription メモ
	 * @return 自オブジェクト
	 */
	public CreateCustomerGatewayRequest withNiftyCustomerGatewayDescription(String niftyCustomerGatewayDescription) {
		setNiftyCustomerGatewayDescription(niftyCustomerGatewayDescription);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[type=");
		builder.append(type);
		builder.append(", ipAddress=");
		builder.append(ipAddress);
		builder.append(", bgpAsn=");
		builder.append(bgpAsn);
		builder.append(", niftyCustomerGatewayName=");
		builder.append(niftyCustomerGatewayName);
		builder.append(", niftyLanSideIpAddress=");
		builder.append(niftyLanSideIpAddress);
		builder.append(", niftyLanSideCidrBlock=");
		builder.append(niftyLanSideCidrBlock);
		builder.append(", niftyCustomerGatewayDescription=");
		builder.append(niftyCustomerGatewayDescription);
		builder.append("]");
		return builder.toString();
	}
}
