/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.customergateway;

import com.nifty.cloud.sdk.BaseClient;
import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.customergateway.model.CreateCustomerGatewayRequest;
import com.nifty.cloud.sdk.customergateway.model.CreateCustomerGatewayResult;
import com.nifty.cloud.sdk.customergateway.model.DeleteCustomerGatewayRequest;
import com.nifty.cloud.sdk.customergateway.model.DeleteCustomerGatewayResult;
import com.nifty.cloud.sdk.customergateway.model.DescribeCustomerGatewaysRequest;
import com.nifty.cloud.sdk.customergateway.model.DescribeCustomerGatewaysResult;
import com.nifty.cloud.sdk.customergateway.model.NiftyModifyCustomerGatewayAttributeRequest;
import com.nifty.cloud.sdk.customergateway.model.NiftyModifyCustomerGatewayAttributeResult;

/**
 * NIFCLOUD API クライアント　具象クラス。
 * カスタマーゲートウェイカテゴリ クライアント。<br />
 * カスタマーゲートウェイ カテゴリの同期クライアントの具象クラスです。<br />
 * 戻り値の"利用不可"パラメータは返却値がnullまたは空となります。
 */
public class NiftyCustomerGatewayClient extends BaseClient implements NiftyCustomerGateway {

	/**
	 * 認証情報を指定し、カスタマーゲートウェイカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 */
	public NiftyCustomerGatewayClient(Credentials credential) {
		super(credential, new ClientConfiguration());
	}

	/**
	 * 認証情報、クライアント設定を指定し、カスタマーゲートウェイカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 * @param configuration クライアント設定
	 */
	public NiftyCustomerGatewayClient(Credentials credential, ClientConfiguration configuration) {
		super(credential, configuration);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.customergateway.NiftyCustomerGateway#createCustomerGateway(com.nifty.cloud.sdk.customergateway.model.CreateCustomerGatewayRequest)
	 */
	@Override
	public CreateCustomerGatewayResult createCustomerGateway(CreateCustomerGatewayRequest request) {
		return (CreateCustomerGatewayResult) client.execute(request, CreateCustomerGatewayResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.customergateway.NiftyCustomerGateway#deleteCustomerGateway(com.nifty.cloud.sdk.customergateway.model.DeleteCustomerGatewayRequest)
	 */
	@Override
	public DeleteCustomerGatewayResult deleteCustomerGateway(DeleteCustomerGatewayRequest request) {
		return (DeleteCustomerGatewayResult) client.execute(request, DeleteCustomerGatewayResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.customergateway.NiftyCustomerGateway#describeCustomerGateways(com.nifty.cloud.sdk.customergateway.model.DescribeCustomerGatewaysRequest)
	 */
	@Override
	public DescribeCustomerGatewaysResult describeCustomerGateways(DescribeCustomerGatewaysRequest request) {
		return (DescribeCustomerGatewaysResult) client.execute(request, DescribeCustomerGatewaysResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.customergateway.NiftyCustomerGateway#niftyModifyCustomerGatewayAttribute(com.nifty.cloud.sdk.customergateway.model.NiftyModifyCustomerGatewayAttributeRequest)
	 */
	@Override
	public NiftyModifyCustomerGatewayAttributeResult niftyModifyCustomerGatewayAttribute(NiftyModifyCustomerGatewayAttributeRequest request) {
		return (NiftyModifyCustomerGatewayAttributeResult) client.execute(request, NiftyModifyCustomerGatewayAttributeResult.class);
	}
}