/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.customergateway;

import java.util.concurrent.Future;

import com.nifty.cloud.sdk.customergateway.model.CreateCustomerGatewayRequest;
import com.nifty.cloud.sdk.customergateway.model.CreateCustomerGatewayResult;
import com.nifty.cloud.sdk.customergateway.model.DeleteCustomerGatewayRequest;
import com.nifty.cloud.sdk.customergateway.model.DeleteCustomerGatewayResult;
import com.nifty.cloud.sdk.customergateway.model.DescribeCustomerGatewaysRequest;
import com.nifty.cloud.sdk.customergateway.model.DescribeCustomerGatewaysResult;
import com.nifty.cloud.sdk.customergateway.model.NiftyModifyCustomerGatewayAttributeRequest;
import com.nifty.cloud.sdk.customergateway.model.NiftyModifyCustomerGatewayAttributeResult;


/**
 * NIFCLOUD API 非同期クライアント　インタフェース。
 * カスタマーゲートウェイカテゴリクライアント。<br />
 * カスタマーゲートウェイ カテゴリの非同期クライアントのインタフェースです。<br />
 * 戻り値の"利用不可"パラメータは返却値がnullまたは空となります。
 */
public interface NiftyCustomerGatewayAsync extends NiftyCustomerGateway {

	/**
	 * 非同期でカスタマーゲートウェイを新規作成します。
	 *
	 * @param request CreateCustomerGatewayリクエスト<br />
	 * &nbsp;	CreateCustomerGatewayRequest#typeは利用不可<br />
	 * &nbsp;	CreateCustomerGatewayRequest#bgpAsnは利用不可
	 * @return 非同期処理結果<br />
	 * &nbsp;	CustomerGateway#typeは利用不可<br />
	 * &nbsp;	CustomerGateway#bgpAsnは利用不可
	 */
	public Future<CreateCustomerGatewayResult> createCustomerGatewayAsync(CreateCustomerGatewayRequest request);


	/**
	 * 非同期で指定したカスタマーゲートウェイを削除します。
	 *
	 * @param request DeleteCustomerGatewayリクエスト
	 * @return 非同期処理結果
	 */
	public Future<DeleteCustomerGatewayResult> deleteCustomerGatewayAsync(DeleteCustomerGatewayRequest request);


	/**
	 * 非同期でカスタマーゲートウェイの情報を取得します。
	 *
	 * @param request DescribeCustomerGatewaysリクエスト
	 * @return 非同期処理結果<br />
	 * &nbsp;	CustomerGateway#typeは利用不可<br />
	 * &nbsp;	CustomerGateway#bgpAsnは利用不可
	 */
	public Future<DescribeCustomerGatewaysResult> describeCustomerGatewaysAsync(DescribeCustomerGatewaysRequest request);


	/**
	 * 非同期で指定したカスタマーゲートウェイの詳細情報を更新します。
	 *
	 * @param request NiftyModifyCustomerGatewayAttributeリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyModifyCustomerGatewayAttributeResult> niftyModifyCustomerGatewayAttributeAsync(NiftyModifyCustomerGatewayAttributeRequest request);

}