/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.customergateway;

import com.nifty.cloud.sdk.customergateway.model.CreateCustomerGatewayRequest;
import com.nifty.cloud.sdk.customergateway.model.CreateCustomerGatewayResult;
import com.nifty.cloud.sdk.customergateway.model.DeleteCustomerGatewayRequest;
import com.nifty.cloud.sdk.customergateway.model.DeleteCustomerGatewayResult;
import com.nifty.cloud.sdk.customergateway.model.DescribeCustomerGatewaysRequest;
import com.nifty.cloud.sdk.customergateway.model.DescribeCustomerGatewaysResult;
import com.nifty.cloud.sdk.customergateway.model.NiftyModifyCustomerGatewayAttributeRequest;
import com.nifty.cloud.sdk.customergateway.model.NiftyModifyCustomerGatewayAttributeResult;

/**
 * NIFCLOUD API クライアント　インタフェース。
 * カスタマーゲートウェイ カテゴリ クライアント。<br />
 * カスタマーゲートウェイ カテゴリの同期クライアントのインタフェースです。<br />
 * 戻り値の"利用不可"パラメータは返却値がnullまたは空となります。
 */
public interface NiftyCustomerGateway {

	/**
	 * エンドポイントの設定を行います。
	 *
	 * @param endpoint エンドポイント
	 */
	public void setEndpoint(String endpoint);

	/**
	 * カスタマーゲートウェイを新規作成します。
	 *
	 * @param request CreateCustomerGatewayリクエスト<br />
	 * &nbsp;	CreateCustomerGatewayRequest#typeは利用不可<br />
	 * &nbsp;	CreateCustomerGatewayRequest#bgpAsnは利用不可
	 * @return CreateCustomerGateway処理結果<br />
	 * &nbsp;	CustomerGateway#typeは利用不可<br />
	 * &nbsp;	CustomerGateway#bgpAsnは利用不可
	 */
	public CreateCustomerGatewayResult createCustomerGateway(CreateCustomerGatewayRequest request);

	/**
	 * 指定したカスタマーゲートウェイを削除します。
	 *
	 * @param request DeleteCustomerGatewayリクエスト
	 * @return DeleteCustomerGateway処理結果
	 */
	public DeleteCustomerGatewayResult deleteCustomerGateway(DeleteCustomerGatewayRequest request);

	/**
	 * カスタマーゲートウェイの情報を取得します。
	 *
	 * @param request DescribeCustomerGatewaysリクエスト
	 * @return DescribeCustomerGateways処理結果<br />
	 * &nbsp;	CustomerGateway#typeは利用不可<br />
	 * &nbsp;	CustomerGateway#bgpAsnは利用不可
	 */
	public DescribeCustomerGatewaysResult describeCustomerGateways(DescribeCustomerGatewaysRequest request);

	/**
	 * 指定したカスタマーゲートウェイの詳細情報を更新します。
	 *
	 * @param request NiftyModifyCustomerGatewayAttributeリクエスト
	 * @return NiftyModifyCustomerGatewayAttribute処理結果
	 */
	public NiftyModifyCustomerGatewayAttributeResult niftyModifyCustomerGatewayAttribute(NiftyModifyCustomerGatewayAttributeRequest request);
}