/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.autoscale.model.transform;

import java.util.List;

import com.nifty.cloud.sdk.autoscale.model.LogSet;
import com.nifty.cloud.sdk.autoscale.model.NiftyDescribeScalingActivitiesResult;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * NiftyDescribeScalingActivitiesResult変換クラス。<br />
 * このクラスはレスポンスXMLのNiftyDescribeScalingActivitiesResponse<br />
 * の要素からNiftyDescribeScalingActivitiesResultクラスを生成します。
 */
public class NiftyDescribeScalingActivitiesResultConverter implements Converter {

    private static final String ELEMENT_REQUEST_ID = "requestId";
    private static final String ELEMENT_AUTO_SCALING_GROUP_NAME = "autoScalingGroupName";
    private static final String ELEMENT_LOG_SET = "logSet";

    /**
     * 変換可能なクラスか判定します。
     *
     * @param type
     *            クラス
     * @return 変換可能な場合true, 変換不可能な場合false
     *
     * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
     */
    @Override
    @SuppressWarnings("rawtypes")
    public boolean canConvert(Class type) {
        return type == NiftyDescribeScalingActivitiesResult.class;
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer,
        MarshallingContext context) {
        // 処理無し
    }

    @Override
    @SuppressWarnings("unchecked")
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {

        NiftyDescribeScalingActivitiesResult result = new NiftyDescribeScalingActivitiesResult();

        LogSetConverter logSetConverter = new LogSetConverter();

        String name = null;

        while (reader.hasMoreChildren()) {

            reader.moveDown();

            name = reader.getNodeName();

            if (name.equals(ELEMENT_REQUEST_ID)) {
                result.setRequestId(reader.getValue());
            } else if (name.equals(ELEMENT_AUTO_SCALING_GROUP_NAME)) {
                result.setAutoScalingGroupName(reader.getValue());
            } else if (name.equals(ELEMENT_LOG_SET)) {
                result.setLogSet((List<LogSet>) logSetConverter.unmarshal(reader, context));
            }

            reader.moveUp();

        }

        return result;
    }

}
