/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.autoscale.model.transform;

import java.util.List;

import com.nifty.cloud.sdk.autoscale.model.AutoScalingReservationSet;
import com.nifty.cloud.sdk.autoscale.model.NiftyDescribeAutoScalingGroupsResult;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * NiftyDescribeAutoScalingGroupsResult変換クラス。<br />
 * このクラスはレスポンスXMLのNiftyDescribeAutoScalingGroupsResponse<br />
 * の要素からNiftyDescribeAutoScalingGroupsResultクラスを生成します。
 */
public class NiftyDescribeAutoScalingGroupsResultConverter implements Converter {

    private static final String ELEMENT_REQUEST_ID = "requestId";
    private static final String ELEMENT_AUTO_SCALING_RESERVATION_SET = "autoScalingReservationSet";

    /**
     * 変換可能なクラスか判定します。
     *
     * @param type
     *            クラス
     * @return 変換可能な場合true, 変換不可能な場合false
     *
     * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
     */
    @Override
    @SuppressWarnings("rawtypes")
    public boolean canConvert(Class type) {
        return type == NiftyDescribeAutoScalingGroupsResult.class;
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer,
        MarshallingContext context) {
        // 処理無し
    }

    @SuppressWarnings("unchecked")
    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {

        NiftyDescribeAutoScalingGroupsResult result = new NiftyDescribeAutoScalingGroupsResult();

        AutoScalingReservationSetConverter autoScalingReservationSetConverter =
            new AutoScalingReservationSetConverter();

        String name = null;

        while (reader.hasMoreChildren()) {

            reader.moveDown();

            name = reader.getNodeName();

            if (name.equals(ELEMENT_REQUEST_ID)) {
                result.setRequestId(reader.getValue());
            } else if (name.equals(ELEMENT_AUTO_SCALING_RESERVATION_SET)) {
                result.setAutoScalingReservationSet(
                    (List<AutoScalingReservationSet>) autoScalingReservationSetConverter
                        .unmarshal(reader, context));
            }

            reader.moveUp();

        }

        return result;
    }

}
