/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.autoscale.model.transform;

import java.util.ArrayList;
import java.util.List;

import com.nifty.cloud.sdk.autoscale.model.GroupSet;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * GroupSet変換クラス。<br />
 * このクラスはレスポンスXMLのgroupSetの要素からGroupSetクラスを生成します。
 */
public class GroupSetConverter implements Converter {

    private static final String ELEMENT_ITEM = "item";
    private static final String ELEMENT_GROUP_ID = "groupId";

    /**
     * 変換可能なクラスか判定します。
     *
     * @param type
     *            クラス
     * @return 変換可能な場合true, 変換不可能な場合false
     *
     * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
     */
    @Override
    @SuppressWarnings("rawtypes")
    public boolean canConvert(Class type) {
        return type == GroupSet.class;
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer,
        MarshallingContext context) {
        // 処理無し
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {

        List<GroupSet> list = new ArrayList<GroupSet>();

        GroupSet groupSet = null;

        String name = null;

        while (reader.hasMoreChildren()) {

            groupSet = new GroupSet();

            reader.moveDown();

            while (reader.hasMoreChildren()) {

                name = reader.getNodeName();

                if (name.equals(ELEMENT_ITEM)) {

                    reader.moveDown();

                    name = reader.getNodeName();

                    if (name.equals(ELEMENT_GROUP_ID)) {
                        groupSet.setGroupId(reader.getValue());
                    }

                }

                reader.moveUp();

            }

            reader.moveUp();

            list.add(groupSet);

        }

        return list;

    }

}
