/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.autoscale.model.transform;

import java.util.ArrayList;
import java.util.List;

import com.nifty.cloud.sdk.autoscale.model.AutoScalingInstancesSet;
import com.nifty.cloud.sdk.autoscale.model.AutoScalingReservationSet;
import com.nifty.cloud.sdk.autoscale.model.GroupSet;
import com.nifty.cloud.sdk.autoscale.model.LoadBalancers;
import com.nifty.cloud.sdk.autoscale.model.NiftyDescribeAutoScalingGroupsResult;
import com.nifty.cloud.sdk.autoscale.model.PlacementSet;
import com.nifty.cloud.sdk.autoscale.model.ScalingSchedule;
import com.nifty.cloud.sdk.autoscale.model.TriggerSet;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * AutoScalingReservationSet変換クラス。<br />
 * このクラスはレスポンスXMLのautoScalingReservationSetの要素からAutoScalingReservationSetクラスを生成します。
 */
public class AutoScalingReservationSetConverter implements Converter {

    private static final String ELEMENT_ITEM = "item";
    private static final String ELEMENT_AUTOSCALING_GROUP_NAME = "autoScalingGroupName";
    private static final String ELEMENT_DESCRIPTION = "description";
    private static final String ELEMENT_IMAGE_ID = "imageId";
    private static final String ELEMENT_INSTANCE_TYPE = "instanceType";
    private static final String ELEMENT_GROUP_SET = "groupSet";
    private static final String ELEMENT_TRIGGER_SET = "triggerSet";
    private static final String ELEMENT_SCALEOUT_CONDITION = "scaleoutCondition";
    private static final String ELEMENT_LOAD_BALANCING = "loadBalancing";
    private static final String ELEMENT_MIN_SIZE = "minSize";
    private static final String ELEMENT_MAX_SIZE = "maxSize";
    private static final String ELEMENT_INSTANCE_LIFECYCLE_LIMIT = "instanceLifecycleLimit";
    private static final String ELEMENT_SCALEOUT = "scaleout";
    private static final String ELEMENT_DEFAULT_COOLDOWN = "defaultCooldown";
    private static final String ELEMENT_CHANGE_IN_CAPACITY = "changeInCapacity";
    private static final String ELEMENT_SCHEDULE_SET = "scheduleSet";
    private static final String ELEMENT_PLACEMENT = "placement";
    private static final String ELEMENT_INSTANCES_SET = "instancesSet";
    private static final String ELEMENT_ALARM = "alarm";
    private static final String ELEMENT_CREATED_TIME = "createdTime";

    private static final String AVAILABILITY_ZONE = "availabilityZone";

    /**
     * 変換可能なクラスか判定します。
     *
     * @param type
     *            クラス
     * @return 変換可能な場合true, 変換不可能な場合false
     *
     * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
     */
    @Override
    @SuppressWarnings("rawtypes")
    public boolean canConvert(Class type) {
        return type == NiftyDescribeAutoScalingGroupsResult.class;
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer,
        MarshallingContext context) {
        // 処理無し
    }

    @SuppressWarnings("unchecked")
    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {

        List<AutoScalingReservationSet> list = new ArrayList<AutoScalingReservationSet>();

        AutoScalingReservationSet set = null;

        GroupSetConverter groupSetConverter = new GroupSetConverter();
        TriggerSetConverter triggerSetConverter = new TriggerSetConverter();
        LoadBalancingSetConverter loadBalancingConverter = new LoadBalancingSetConverter();
        ScheduleSetConverter scheduleSetConverter = new ScheduleSetConverter();
        AutoScalingInstancesSetConverter autoScalingInstancesSetConverter =
            new AutoScalingInstancesSetConverter();

        String name = null;

        while (reader.hasMoreChildren()) {

            set = new AutoScalingReservationSet();

            reader.moveDown();

            while (reader.hasMoreChildren()) {

                name = reader.getNodeName();

                if (name.equals(ELEMENT_ITEM)) {

                    reader.moveDown();

                    name = reader.getNodeName();

                    if (name.equals(ELEMENT_AUTOSCALING_GROUP_NAME)) {
                        set.setAutoScalingGroupName(reader.getValue());
                    } else if (name.equals(ELEMENT_DESCRIPTION)) {
                        set.setDescription(reader.getValue());
                    } else if (name.equals(ELEMENT_IMAGE_ID)) {
                        set.setImageId(reader.getValue());
                    } else if (name.equals(ELEMENT_INSTANCE_TYPE)) {
                        set.setInstanceType(reader.getValue());
                    } else if (name.equals(ELEMENT_GROUP_SET)) {
                        set.setGroupSet(
                            (List<GroupSet>) groupSetConverter.unmarshal(reader, context));
                    } else if (name.equals(ELEMENT_TRIGGER_SET)) {
                        set.setTriggerSet(
                            (List<TriggerSet>) triggerSetConverter.unmarshal(reader, context));
                    } else if (name.equals(ELEMENT_SCALEOUT_CONDITION)) {
                        set.setScaleoutCondition(reader.getValue());
                    } else if (name.equals(ELEMENT_LOAD_BALANCING)) {
                        set.setLoadBalancers((List<LoadBalancers>) loadBalancingConverter
                            .unmarshal(reader, context));
                    } else if (name.equals(ELEMENT_MIN_SIZE)) {
                        set.setMinSize(Integer.parseInt(reader.getValue()));
                    } else if (name.equals(ELEMENT_MAX_SIZE)) {
                        set.setMaxSize(Integer.parseInt(reader.getValue()));
                    } else if (name.equals(ELEMENT_INSTANCE_LIFECYCLE_LIMIT)) {
                        set.setInstanceLifecycleLimit(Integer.parseInt(reader.getValue()));
                    } else if (name.equals(ELEMENT_SCALEOUT)) {
                        set.setScaleout(Integer.parseInt(reader.getValue()));
                    } else if (name.equals(ELEMENT_DEFAULT_COOLDOWN)) {
                        set.setDefaultCooldown(Integer.parseInt(reader.getValue()));
                    } else if (name.equals(ELEMENT_CHANGE_IN_CAPACITY)) {
                        set.setChangeInCapacity(Integer.parseInt(reader.getValue()));
                    } else if (name.equals(ELEMENT_SCHEDULE_SET)) {
                        set.setScalingSchedule(
                            (List<ScalingSchedule>) scheduleSetConverter.unmarshal(reader,
                                context));
                    } else if (name.equals(ELEMENT_PLACEMENT)) {

                        while (reader.hasMoreChildren()) {

                            reader.moveDown();

                            name = reader.getNodeName();

                            if (name.equals(AVAILABILITY_ZONE)) {

                                PlacementSet placementSet = new PlacementSet();

                                placementSet.setAvailabilityZone(reader.getValue());

                                set.setPlacementSet(placementSet);

                            }

                            reader.moveUp();

                        }

                    } else if (name.equals(ELEMENT_INSTANCES_SET)) {
                        set.setAutoScalingInstancesSet(
                            (List<AutoScalingInstancesSet>) autoScalingInstancesSetConverter
                                .unmarshal(reader, context));
                    } else if (name.equals(ELEMENT_ALARM)) {
                        set.setAlarm(reader.getValue());
                    } else if (name.equals(ELEMENT_CREATED_TIME)) {
                        set.setCreatedTime(reader.getValue());
                    }

                }

                reader.moveUp();

            }

            reader.moveUp();

            list.add(set);

        }

        return list;

    }

}
