/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.autoscale.model.transform;

import java.util.ArrayList;
import java.util.List;

import com.nifty.cloud.sdk.autoscale.model.AutoScalingInstancesSet;
import com.nifty.cloud.sdk.autoscale.model.InstanceState;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * AutoScalingInstancesSet変換クラス。<br />
 * このクラスはレスポンスXMLのinstancesSetの要素からAutoScalingInstancesSetクラスを生成します。
 */
public class AutoScalingInstancesSetConverter implements Converter {

    private static final String ELEMENT_ITEM = "item";

    private static final String ELEMENT_INSTANCE_ID = "instanceId";
    private static final String ELEMENT_INSTANCE_UNIQUE_ID = "instanceUniqueId";
    private static final String ELEMENT_INSTANCE_STATE = "instanceState";
    private static final String ELEMENT_CODE = "code";
    private static final String ELEMENT_NAME = "name";
    private static final String ELEMENT_DNS_NAME = "dnsName";
    private static final String ELEMENT_INSTANCE_TYPE = "instanceType";
    private static final String ELEMENT_EXPIRE_TIME = "expireTime";

    /**
     * 変換可能なクラスか判定します。
     *
     * @param type
     *            クラス
     * @return 変換可能な場合true, 変換不可能な場合false
     *
     * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
     */
    @Override
    @SuppressWarnings("rawtypes")
    public boolean canConvert(Class type) {
        return type == AutoScalingInstancesSet.class;
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer,
        MarshallingContext context) {
        // 処理無し
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {

        List<AutoScalingInstancesSet> list = new ArrayList<AutoScalingInstancesSet>();

        AutoScalingInstancesSet set = null;

        InstanceState state = null;

        String name = null;

        while (reader.hasMoreChildren()) {

            set = new AutoScalingInstancesSet();
            state = new InstanceState();

            reader.moveDown();

            while (reader.hasMoreChildren()) {

                name = reader.getNodeName();

                if (name.equals(ELEMENT_ITEM)) {

                    reader.moveDown();

                    name = reader.getNodeName();

                    if (name.equals(ELEMENT_INSTANCE_ID)) {
                        set.setInstanceId(reader.getValue());
                    } else if (name.equals(ELEMENT_INSTANCE_UNIQUE_ID)) {
                        set.setInstanceUniqueId(reader.getValue());
                    } else if (name.equals(ELEMENT_INSTANCE_STATE)) {

                        while (reader.hasMoreChildren()) {

                            reader.moveDown();

                            name = reader.getNodeName();

                            if (name.equals(ELEMENT_CODE)) {
                                state.setCode(reader.getValue());
                            } else if (name.equals(ELEMENT_NAME)) {
                                state.setName(reader.getValue());
                            }

                            reader.moveUp();

                        }

                        set.setInstanceState(state);

                    } else if (name.equals(ELEMENT_DNS_NAME)) {
                        set.setDnsName(reader.getValue());
                    } else if (name.equals(ELEMENT_INSTANCE_TYPE)) {
                        set.setInstanceType(reader.getValue());
                    } else if (name.equals(ELEMENT_EXPIRE_TIME)) {
                        set.setExpireTime(reader.getValue());
                    }

                }

                reader.moveUp();

            }

            reader.moveUp();

            set.setInstanceState(state);

            list.add(set);

        }

        return list;
    }

}
